#ifndef ARTDISPLAYDEVICE_H
#define ARTDISPLAYDEVICE_H

/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: ArtDisplayDevice.h,v $
 *	$Author: ulrich $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1997/03/21 17:38:30 $
 *
 ***************************************************************************
 * DESCRIPTION: 
 *   Writes to the ART raytracer.  This is available from gondwana.ecr.mu.oz.au
 * as part of the vort package.
 *
 ***************************************************************************/


#include <stdio.h>
#include "FileRenderer.h"


class ArtDisplayDevice : public FileRenderer {

private:

  
  // output file name
  char *art_filename;
  
  // was the file created?
  int Initialized;

protected:

  //
  // assorted graphics functions
  //
  
  void point(float *);
  void sphere(float *);
  void line(float *, float *);
  void cylinder(float *, float *, float,int filled);
  void cone(float *, float *, float); 
  void triangle(float *, float *, float *, float *, float *, float *);
  void square(float *, float *, float *, float *, float *);
  void comment (char *);

public: 
  // constructor/destructor

  ArtDisplayDevice();
  virtual ~ArtDisplayDevice(void);
  
  void write_header(void);
  void write_trailer(void);
  
}; 

#endif

