/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: AtomColor.h,v $
 *      $Author: dalke $        $Locker:  $                $State: Exp $
 *      $Revision: 1.10 $      $Date: 1996/02/01 23:58:21 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * 
 * Parse and maintain the data for how a molecule should be colored.
 *
 ***************************************************************************/
#ifndef ATOMCOLOR_H
#define ATOMCOLOR_H

#include "utilities.h"
class MoleculeList;
class DrawMolecule;
class ColorList;

// default atom coloring method, and max cmd string size
#define DEFAULT_ATOMCOLOR	AtomColor::NAME
#define MAX_ATOMCOLOR_CMD	255

class AtomColor {

public:
  // different methods for coloring atoms
  enum ColorMethod { NAME, TYPE, RESNAME, RESTYPE, RESID, CHAIN, SEGNAME, 
		     MOLECULE, STRUCTURE, COLORID, BETA, OCCUP, MASS, 
		     CHARGE, POS, INDEX, BACKBONE, TOTAL };
	
  // initial string with representation command
  char cmdStr[MAX_ATOMCOLOR_CMD + 1];
  
  // color determined for each atom
  int *color;

  // number of atoms these colors are for
  int nAtoms;

private:
  // results of command ... how to represent atoms, and some parameters
  ColorMethod colorMethod;
  int colIndex;			// index, if method = INDEX
  int transpar;			// use transparent color?
  
  // color list object this object should use
  ColorList *colList;

  // the list of molecules to use for data ... may be NULL
  MoleculeList *molList;

  // molecule used to base the selection on
  DrawMolecule *mol;

  // parse the given command, and store results.  Return success.
  int parse_cmd(char *);

public:
  AtomColor(MoleculeList *, ColorList *);
  AtomColor(AtomColor &);
  ~AtomColor(void);
  
  // equal operator, to change the current settings.
  AtomColor& operator=(const AtomColor &);

  // return whether the given colorlist and color category index are the
  // settings for the current coloring method
  int current_color_use(ColorList *, int);

  // find the color index for the atoms of the given molecule. Return success.
  int find(DrawMolecule *);

  // provide new settings; does a 'find' at the end if a mol has
  // been previously provided.
  int change(char *newcmd) {
    int retval = parse_cmd(newcmd);
    if(retval && mol)
      retval = find(mol);
    return retval;
  }

  //
  // info about current settings
  //

  // return representation method
  int method(void) { return colorMethod; }
  
  // return color index (may not be applicable)
  int color_index(void) { return colIndex; }
  
  // return if color should be transparent
  int transparent(void) { return transpar; }

};

// a string array with text descriptions of representation methods
extern char *AtomColorName[AtomColor::TOTAL];

#endif

