/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Axes.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.8 $	$Date: 1995/11/15 04:29:29 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A Displayable3D object which consists of a set of axes, which may be
 * drawn anywhere on the screen, at any size.
 *
 ***************************************************************************/
#ifndef AXES_H
#define AXES_H

#include "Displayable.h"
#include "DispCmds.h"


class Axes : public Displayable3D {

public:
  // locations for the axes
  enum AxesPos { NO_AXES = 0, AXES_ORIGIN, AXES_LOWERLEFT, 
  	AXES_LOWERRIGHT, AXES_UPPERLEFT, AXES_UPPERRIGHT, AXESPOS_TOTAL };

private:
  // lines defining the axes
  float origin[3], xLine[3], yLine[3], zLine[3];
  float xLineCap[3], yLineCap[3], zLineCap[3];
  float xText[3], yText[3], zText[3];

  // current axes position
  int axesPos;
  
  // most recent aspect ratio of the display
  float Aspect;

  // integer for color category with the colors to use.  If < 0, use
  // default colors
  int colorCat;

  // useful display command objects
  DispCmdSphereRes sphres;
  DispCmdSphereType sphtype;
  DispCmdMaterials cmdMaterials;
  DispCmdColorIndex xcol;
  DispCmdCylinder xcyl;
  DispCmdCone xcap;
  DispCmdSphere sph;
  DispCmdTextPos txtpos;
  DispCmdText xtxt;
  DispCmdText ytxt;
  DispCmdText ztxt;
  DispCmdPickPoint pickPoint;

  // regenerate the command list, and flag for saying we need to do so
  int need_create_cmdlist;
  void create_cmdlist(void);

  // have we moved the axes with the pointer?
  int movedAxes;

protected:
  // do action when a new color list is provided
  virtual void do_use_colors(void);

  // do action due to the fact that a color for the given ColorList for
  // the specified category has changed
  virtual void do_color_changed(ColorList *, int);

public:
  // constructor: the Scene to register this with
  Axes(Scene *);
  virtual ~Axes(void);

  // set axes display mode; return success
  int location(int);

  // return axes display mode
  int location(void) { return axesPos; }

  // return descripton of location
  char *loc_description(int);

  // return total number of locations
  int locations(void) { return AXESPOS_TOTAL; }

  //
  // public virtual specialized popup menu routines
  //

  // Create a popup menu, with the given name; return NULL if none available
  // subclasses should have the parent first create a menu, and then add items
  // to the end of it.  The 1st argument is the tag of the selected item.
  virtual PopupMenu *create_popup_menu(int);

  //
  // public virtual drawing routines
  //
  
  // prepare for drawing ... do any updates needed right before draw.
  virtual void prepare(DisplayDevice *);

  //
  // public virtual picking routines
  //

  // return if we are interested in the given pick mode or not ... here, we
  // are interested in ALL modes
  virtual int want_pick_mode(int);

  // called when a pick moves:
  //	args = display to use, obj picked, button, mode, tag, dim, pos
  // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
  // For 3D version: x,y,z are transformed position of pointer
  // For the Axes, when they are selected and the pointer moves, we wish
  // to move the axes as well.
  virtual void pick_move(DisplayDevice *, Pickable *,
  				int, int, int, int, float *);
  
  // we do NOT need a special version of pick_start or pick_end in this case.

};

#endif

