/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: BabelConvert.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1995/05/11 21:36:24 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * A set of routines for manipulating Babel to convert file formats
 * into PDB format
 *
 ***************************************************************************/
#ifndef BABELCONVERT_H
#define BABELCONVERT_H

// Babel is a general molecular coordinate conversion program
// It is available via anonymous ftp to joplin.biosci.arizona.edu

// given the filename for the original file (like "file.xyz"),
// the frame (from 0 to num-1) and the number of frames,
// return the correct filename.  I need to know the number of
// files since babel converts multi-frame data formats to
// "file00001.pdb", ....
// but single frame formats to "file.pdb"
//  Also, if num==-1, this returns the string needed to delete (or find)
// all files that match this file (eg, "/tmp/vmdbabel*.file.xyz")
//  If num==-2, this converts it into a very special format needed for
// sscanf to parse the dir list to check for the number of files made
const char *babel_file(const char *filename, int idx, int num);

// deletes all files that could have been made by "filename"
// in this case, it system("/bin/rm -f file.expansion")
// where the expansion was defined by the -1 string of babel_file
void babel_delete_all(const char *filename);

// convert the file of the given type to PDB
// returns the number of elements made
// or 0 if there was an error
int babel_convert(int moltype, const char *filename); 

#endif

