/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: CmdAnimate.h,v $
 *      $Author: dalke $        $Locker:  $                $State: Exp $
 *      $Revision: 1.7 $      $Date: 1996/12/12 21:32:03 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * 
 * Command objects for doing animation.
 *
 ***************************************************************************/
#ifndef CMDANIMATE_H
#define CMDANIMATE_H

#include "Command.h"
#include "Animation.h"
#include "MoleculeList.h"
#include "MolAction.h"

// The following uses  the Cmdtypes:
//	ANIM_DIRECTION, ANIM_JUMP, ANIM_SKIP, ANIM_STYLE, ANIM_SPEED,
//	ANIM_READ, ANIM_WRITE, ANIM_DELETE

// text callback routine for 'animate'
typedef struct Tcl_Interp;
extern int text_cmd_animate(int, char **, CommandQueue *, int, Tcl_Interp *);


//////////////////// set direction of animation
class CmdAnimDir : public Command {

public:
  // new direction
  Animation::AnimDir newDir;
  
  // which molecules to affect
  MoleculeList::ActionTarget whichMol;

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdAnimDir(Animation::AnimDir, int newUIid=(-1));
};


//////////////////// set style of animation
class CmdAnimStyle : public Command {

public:
  // new direction
  Animation::AnimStyle newStyle;
  
  // which molecules to affect
  MoleculeList::ActionTarget whichMol;

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdAnimStyle(Animation::AnimStyle, int newUIid=(-1));
};


//////////////////// jump to a new frame
class CmdAnimJump : public Command {

public:
  // new frame ... could also indicate to move to beginning or end
  int newFrame;
  
  // which molecules to affect
  MoleculeList::ActionTarget whichMol;

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdAnimJump(int, int newUIid=(-1));
};


//////////////////// set frame skip value
class CmdAnimSkip : public Command {

public:
  // new frame skip
  int newSkip;
  
  // which molecules to affect
  MoleculeList::ActionTarget whichMol;

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdAnimSkip(int, int newUIid=(-1));
};


//////////////////// set animation speed
class CmdAnimSpeed : public Command {

public:
  // new speed
  float newSpeed;
  
  // which molecules to affect
  MoleculeList::ActionTarget whichMol;

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdAnimSpeed(float, int newUIid=(-1));
};


//////////////////// append new frames from a file
class CmdAnimReadFile : public Command {

public:
  int whichMol;				// which molecule to affect
  int fileType;				// kind of file to read
  int begFrame, endFrame, frameSkip;	// frames to read
  char *fileName;			// name of file to read

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdAnimReadFile(int m, char *, int t, int bf, int ef, int fs,
  			int newUIid=(-1));
  virtual ~CmdAnimReadFile(void);
};

//////////////////// append new frames from a file, then delete the file
class CmdAnimReadFileDelete : public Command {

public:
  int whichMol;				// which molecule to affect
  int fileType;				// kind of file to read
  int begFrame, endFrame, frameSkip;	// frames to read
  char *fileName;			// name of file to read

protected:
  virtual int do_execute(void);

public:
  CmdAnimReadFileDelete(int m, char *, int t, int bf, int ef, int fs,
  			int newUIid=(-1));
  virtual ~CmdAnimReadFileDelete(void);
};


//////////////////// write frames to a file
class CmdAnimWriteFile : public Command {

public:
  int whichMol;				// which molecule to affect
  int fileType;				// kind of file to write
  int begFrame, endFrame, frameSkip;	// frames to write
  char *fileName;			// name of file to write

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdAnimWriteFile(int m, char *, int t, int bf, int ef, int fs,
  			int newUIid=(-1));
  virtual ~CmdAnimWriteFile(void);
};


//////////////////// delete frames
class CmdAnimDelete : public Command {

public:
  int whichMol;				// which molecule to affect
  int begFrame, endFrame, frameSkip;	// frames to delete

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdAnimDelete(int m, int bf, int ef, int fs, int newUIid=(-1));
};

///////////////////// duplicate a given frame at the end of the traj.
class CmdAnimDup : public Command {

public:
  int whichMol;                          // which molecule to affect
  int whichFrame;                        // which frame to copy

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdAnimDup(int frame, int molid, int newUIid=(-1));
};

#endif

