/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdMouse.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1996/12/12 21:32:03 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Commands to control the state of the Mouse object
 *
 ***************************************************************************/
#ifndef CMDMOUSE_H
#define CMDMOUSE_H

#include "Command.h"


// The following use MOUSE_MODE

// text callback routine for 'mouse'
typedef struct Tcl_Interp;
extern int text_cmd_mouse(int, char **, CommandQueue *, int, Tcl_Interp *);


////////////////////// change the current mouse mode ... this command
////////////////////// does not generate an output text command, it is just
////////////////////// used to change the VMD internal state
class CmdMouseMode : public Command {
private:
  // mode and setting for the mouse
  int mouseMode, mouseSetting;

protected:
  virtual int do_execute(void);

public:
  // specify new mode and setting
  CmdMouseMode(int, int, int = -1);
};


#endif

