/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: CmdRemote.h,v $
 *      $Author: dalke $        $Locker:  $                $State: Exp $
 *      $Revision: 1.5 $      $Date: 1996/12/12 21:32:03 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * 
 * Command objects for affecting remote connections.
 *
 ***************************************************************************/
#ifndef CMDREMOTE_H
#define CMDREMOTE_H

#include "Command.h"

// the following uses the Cmdtypes REMOTE_INIT, REMOTE_CANCEL, REMOTE_LIST,
//	REMOTE_NEW, REMOTE_ATTACH, REMOTE_RUN, REMOTE_SETOPT, REMOTE_READOPT,
//	REMOTE_WRITEOPT,
//	SIM_SETPARAM, SIM_PATCHDISP, SIM_TOP, SIM_DETACH, SIM_KILL, SIM_LIST

// text callback routine for 'remote' and 'sim'
typedef struct Tcl_Interp;
extern int text_cmd_remote(int, char **, CommandQueue *, int, Tcl_Interp *);
extern int text_cmd_sim(int, char **, CommandQueue *, int, Tcl_Interp *);


///////////// initialize remote with a new connection
class CmdRemoteInit : public Command {
private:
  char *username, *computer;	// username and computer to use

protected:
  virtual int do_execute(void);
  virtual void create_text(void);
  
public:
  CmdRemoteInit(char *, char *, int=(-1));
  virtual ~CmdRemoteInit(void);
};


//////////// cancel the current connection
class CmdRemoteCancel : public Command {
protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdRemoteCancel(int=(-1));
};


/////////////// list the current remote objects settings
class CmdRemoteList : public Command {
public:
  // what to list (default is ALL)
  enum RemoteList { ALL, JOBS, APPS, PARAMS };

private:
  RemoteList whatToList;		// what should be displayed?

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdRemoteList(RemoteList, int=(-1));
};


/////////////// set the remote connection setup to get the parameters
/////////////// to start a new job on the remote computer, using the selected
/////////////// app.  App is an index into the list of possible applications
/////////////// that can be started.
class CmdRemoteNew : public Command {
private:
  int whichApp;			// index of application to select

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdRemoteNew(int, int=(-1));
};


/////////////// have the remote simulation attach to the specified currently-
/////////////// running job ... a new molecule will be created if this is
/////////////// successful
class CmdRemoteAttach : public Command {
private:
  int whichJob;			// index of job to attach to

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdRemoteAttach(int, int=(-1));
};


/////////////// creates a new simulation using previously established
/////////////// parameters.  Only works if a CmdRemoteNew command has been
/////////////// executed previously
class CmdRemoteRun : public Command {
protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdRemoteRun(int=(-1));
};


/////////////// sets the value for the Nth parameter in the current
/////////////// remote simulation being set up.  Only works if parameters
/////////////// are being edited.
class CmdRemoteSetopt : public Command {
private:
  char *keyword;			// or, can use a keyword to specify
  char *paramVal;			// new value for parameter

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdRemoteSetopt(char *, char *, int=(-1));
  virtual ~CmdRemoteSetopt(void);
};


/////////////// read in parameter values from the given file.
/////////////// Only works if a CmdRemoteNew command has been
/////////////// executed previously
class CmdRemoteReadopt : public Command {
private:
  char *fname;				// name of file

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdRemoteReadopt(char *, int=(-1));
  virtual ~CmdRemoteReadopt(void);
};


/////////////// write current parameter values to the given file.
/////////////// This will work as long as the current remote object has
/////////////// any parameters to write.
class CmdRemoteWriteopt : public Command {
private:
  char *fname;				// name of file

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdRemoteWriteopt(char *, int=(-1));
  virtual ~CmdRemoteWriteopt(void);
};


/////////////// issue command to change parameter for top remote connection.
class CmdRemoteChangeParam : public Command {
private:
  char *param;				// which parameter
  char *newval;				// new value

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdRemoteChangeParam(char *, char *, int=(-1));
  virtual ~CmdRemoteChangeParam(void);
};


/////////////// change how patches are displayed (if they are even available)
class CmdRemotePatchDisplay : public Command {
private:
  int newval;			// new display setting

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdRemotePatchDisplay(char *, int=(-1));
  CmdRemotePatchDisplay(int, int=(-1));
};


/////////////// set the specified molecule as the top remote connection
class CmdRemoteTop : public Command {
private:
  int id;			// which molecule to make top (ID of molecule)

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdRemoteTop(int, int=(-1));
};


/////////////// detach from a running simulation, but don't kill it
class CmdRemoteDetach : public Command {
private:
  int id;			// which molecule to detach (ID of molecule)

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdRemoteDetach(int, int=(-1));
};


/////////////// kill a running simulation
class CmdRemoteKill : public Command {
private:
  int id;			// which molecule to kill (ID of molecule)

protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdRemoteKill(int, int=(-1));
};


/////////////// list all current and previous simulations
class CmdRemoteSimList : public Command {
protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  CmdRemoteSimList(int=(-1));
};


#endif

