/***************************************************************************
 *cr
 *cr		(C) Copyright 1995 The Board of Trustees of the
 *cr			    University of Illinois
 *cr			     All Rights Reserved
 *cr
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdSigma.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 96/12/12 21:32:03 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Command objects for affecting Sigma interface
 *
 ***************************************************************************/
#ifndef CMDSIGMA_H
#define CMDSIGMA_H

#include "Command.h"
#include <mdio/global.h>

// the following defines commands for the Cmdtypes:
// SIGMA_EVENT

// text callback routine for 'sigma'
typedef struct Tcl_Interp;
extern int text_cmd_sigma(int, char **, CommandQueue *, int, Tcl_Interp *);

class MoleculeSigma;

///////////////////// Send an event to Sigma
class CmdSigmaEvent : public Command {
private:
    static MoleculeSigma *sigma;

    enum param_type {
	EV_NO_PARAM,
	EV_INT_PARAM,
	EV_FLOAT_PARAM,
	EV_POINT3_PARAM,
	EV_TUGINFO_PARAM
    };

    param_type paramType;
    int event;	  // event number
    int param;	  // numeric parameter
    float fparam; // numeric parameter
    float x,y,z;  // Point3 parameter
    TugInfo tparam; // TugInfo parameter

protected:
    virtual int do_execute(void) ;
    virtual void create_text(void);

public:
    CmdSigmaEvent(int, int newUIid);
    CmdSigmaEvent(int, int, int newUIid);
    CmdSigmaEvent(int, float, int newUIid);
    CmdSigmaEvent(int, float, float, float, int newUIid);
    CmdSigmaEvent(int, TugInfo &, int newUIid);

    static void register_simulation(MoleculeSigma *);
};


#endif
