/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CmdTool.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.6 $	$Date: 1996/12/12 21:32:03 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Commands which control the tool 
 *
 ***************************************************************************/
#ifndef CMDTOOL_H
#define CMDTOOL_H

// Commands which can be sent to the Tools
#include "Command.h"
class Tool;

// text callback routine for 'tool'
typedef struct Tcl_Interp;
extern int text_cmd_tool(int, char **, CommandQueue *, int, Tcl_Interp *);


//////////////////// return the base characteristics of a Tool
// ie., size, length, detail, and tool name
class CmdToolInfo : public Command {
protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  int toolid;
  CmdToolInfo(int which_tool, int UIid = -1);
};


//////////////////// set the tool's base characteristics to a specific number
class CmdToolSetSize : public Command {
protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  int toolid;
  float scale, length;
  int detail;
  CmdToolSetSize(int which_tool, 
                 float new_scale = 0.0,  // overall scaling factor >0
                 float new_length = 0.0, // length of tool >0
                 int new_detail = 0,     // detail ranges from 1 to 10 (best)
                 int UIid = -1);         // defaults do nothing
};


////////////////// alter the tool's base characteristics by a relative number
class CmdToolAddSize : public Command {
protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  int toolid;
  float scale, length;
  int detail;
  CmdToolAddSize(int which_tool, 
                 float new_scale = 0.0,
                 float new_length = 0.0,
                 int new_detail = 0,    
                 int UIid = -1);
};


//////////////////// change the offset to some new position
class CmdToolSetOffset : public Command {
protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  int toolid;
  float delta[3];
  CmdToolSetOffset(int which_tool, float *newpos, int UIid = -1);
  CmdToolSetOffset(int which_tool, float x, float y, float z, int UIid = -1);
};


//////////////////// change the offset by some relative amount
class CmdToolAddOffset : public Command {
protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  int toolid;
  float delta[3];
  CmdToolAddOffset(int which_tool, float *newpos, int UIid = -1);
  CmdToolAddOffset(int which_tool, float x, float y, float z, int UIid = -1);
};


//////////////////// put another tool on the ToolControl stack
class CmdToolPush : public Command {
protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  int toolid;
  char *tool;
  CmdToolPush(int which_tool, char *newtool, int UIid = -1);
  virtual ~CmdToolPush(void);
};


//////////////////// take a tool off the ToolControl stack
class CmdToolPop : public Command {
protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  int toolid;
  CmdToolPop(int which_tool, int UIid = -1);
};


//////////////////// replace the top tool with another
class CmdToolReplace : public Command {
protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  int toolid;
  char *tool;
  CmdToolReplace(int which_tool, char *newtool, int UIid = -1);
  virtual ~CmdToolReplace(void);
};


//////////////////// emulate a button press or release on the given tool
class CmdToolButton : public Command {
protected:
  virtual int do_execute(void);
  virtual void create_text(void);

public:
  int toolid;
  int buttonid;
  int state;    // 1 is press (or remain pressed) and 0 is release
  CmdToolButton(int which_tool, int which_button, int go_down, int UIid = -1);
};

#endif

