/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: CmdTrans.h,v $
 *      $Author: dalke $        $Locker:  $                $State: Exp $
 *      $Revision: 1.11 $      $Date: 1996/12/12 21:32:03 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * 
 * Command objects for transforming the current scene.
 *
 ***************************************************************************/
#ifndef CMDTRANS_H
#define CMDTRANS_H

#include "Command.h"
#include "Matrix4.h"

// The following uses the Cmdtypes ROTATE, TRANSLATE, SCALE, ROCKON, ROCKOFF,
// STOPROT from the Command class

// text callback routine for 'rotate', 'translate', 'scale', 'rock'
typedef struct Tcl_Interp;
extern int text_cmd_rotmat(int, char **, CommandQueue *, int, Tcl_Interp *);
extern int text_cmd_rotate(int, char **, CommandQueue *, int, Tcl_Interp *);
extern int text_cmd_translate(int, char **, CommandQueue *, int, Tcl_Interp *);
extern int text_cmd_scale(int, char **, CommandQueue *, int, Tcl_Interp *);
extern int text_cmd_rock(int, char **, CommandQueue *, int, Tcl_Interp *);


///////////////// apply a matrix transformation to the current scene
class CmdRotMat : public Command {
 public:
   // is the transformation applied to the current one or is it
   // a replacement?
   enum { BY, TO };

 private:
   Matrix4 rotMat;
   int byOrTo;

 protected:
   virtual int do_execute(void);
   virtual void create_text(void);

 public:
   CmdRotMat(const Matrix4& newrot, int by_or_to, int newUIid=(-1));
};

///////////////// rotate the current scene
class CmdRotate : public Command {
public:
  // enum with how to rotate, 'by' or 'to'
  enum { BY, TO };

public:
  // axis to rotate
  char axis;
  
  // amount to rotate
  float deg;
  
  // set, or add to, rotation?
  int byOrTo;
  
  // steps to rotate through; by default this is 1
  int steps;

protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);

public:
  // first constructor: a single rotation, no smooth transition
  CmdRotate(float a, char ax, int by_or_to, int newUIid=(-1));
  
  // second constructor: a smooth rotation in given increments ...
  // only useful for "by" rotations.  If "to" is given to this constructor,
  // a single-step rotation is done 
  CmdRotate(float a, char ax, int by_or_to, float inc, int newUIid=(-1));
};

///////////////// translate the current scene
class CmdTranslate : public Command {
public:
  // enum with how to translate, 'by' or 'to'
  enum { BY, TO };

public:
  // amount to translate
  float x, y, z;
  
  // set, or add to, translation?
  int byOrTo;
  
protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);

public:
  CmdTranslate(float nx, float ny, float nz, int by_or_to, int newUIid=(-1));
};


///////////////// scale the current scene
class CmdScale : public Command {
public:
  // enum with how to scale, 'by' or 'to'
  enum { BY, TO };

public:
  // amount to scale
  float s;
  
  // set, or multiply, scaling?
  int byOrTo;
  
protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);

public:
  CmdScale(float ns, int by_or_to, int newUIid=(-1));
};


///////////////// rock the current scene
class CmdRockOn : public Command {
public:
  // axis to rock
  char axis;
  
  // amount to rock
  float deg;

  // steps to rock (if < 0, continuous)
  int steps;

protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);

public:
  CmdRockOn(float a, char ax, int nsteps, int newUIid=(-1));
};


///////////////// stop rocking the current scene
class CmdRockOff : public Command {
protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);

public:
  CmdRockOff(int newUIid=(-1)) ;
};


///////////////// stop rotating (both rocking, and mouse movement) for
///////////////// the current scene
class CmdStopRot : public Command {
protected:
  virtual int do_execute(void) ;
  virtual void create_text(void);

public:
  CmdStopRot(int newUIid=(-1)) ;
};


#endif

