/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Command.C,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.6 $	$Date: 1997/03/24 17:21:32 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *     This file contains the base definition of the Command object.
 *  The idea is that all actions should be instantiated as
 *  a derivitive of a Command object and placed in a command queue.
 *  At every event loop, the commands are read off the current command
 *  queue and told to "execute".  When each command
 *  is finished, all of the UIs are notified that a command of some 
 *  "cmdtype" executed, so that the UI can update its information 
 *  if so desired.
 *
 ***************************************************************************/

#include "Command.h"
#include "utilities.h"

char *commandName[Command::TOTAL];
char *commandEventName[Command::TOTAL];

// a little macro to make things easier
#define ASSOC(command,name,clss)  \
commandEventName[Command:: command] = clss; \
commandName[Command:: command] = name;      \
i++;
static void do_command_initialization(void)
{
  int i = 0;
  // initialize everything to "error", just in case
  for (i=0; i<Command::TOTAL; i++) {
    commandName[i] = "error";
    commandEventName[i] = "error";
  }
  i=0;
  ASSOC(NOTHING, "nothing", "nothing");
  ASSOC(WIN_EVENT, "WIN_EVENT", "ui");
  ASSOC(GUI_EVENT, "GUI_EVENT", "ui");
  ASSOC(TEXT_EVENT, "TEXT_EVENT", "ui");
  ASSOC(RESET, "RESET", "nothing");
  ASSOC(QUIT, "QUIT", "ui");
  ASSOC(DEBUG, "DEBUG", "ui");
  ASSOC(ECHO, "ECHO", "ui");
  ASSOC(WAIT, "WAIT", "ui");
  ASSOC(LOGWRITE, "LOGWRITE", "ui");
  ASSOC(LOGREAD, "LOGREAD", "ui");
  ASSOC(ROTMAT, "ROTMAT", "move_scene");
  ASSOC(ROTATE, "ROTATE", "move_scene");
  ASSOC(TRANSLATE, "TRANSLATE", "move_scene");
  ASSOC(SCALE, "SCALE", "move_scene");
  ASSOC(ROCKON, "ROCKON", "move_scene");
  ASSOC(ROCKOFF, "ROCKOFF", "move_scene");
  ASSOC(STOPROT, "STOPROT", "move_scene");

  ASSOC(ANIM_DIRECTION, "ANIM_DIRECTION", "animate");
  ASSOC(ANIM_JUMP, "ANIM_JUMP", "animate");
  ASSOC(ANIM_SKIP, "ANIM_SKIP", "animate");
  ASSOC(ANIM_STYLE, "ANIM_STYLE", "animate");
  ASSOC(ANIM_SPEED, "ANIM_SPEED", "animate");
  ASSOC(ANIM_READ, "ANIM_READ", "animate");
  ASSOC(ANIM_WRITE, "ANIM_WRITE", "animate");
  ASSOC(ANIM_DELETE, "ANIM_DELETE", "animate");
  ASSOC(ANIM_READ_DELETE_FILE, "ANIM_READ_DELETE_FILE", "animate");
  ASSOC(ANIM_DUP, "ANIM_DUP", "animate");

  ASSOC(COLOR_NAME, "COLOR_NAME", "color");
  ASSOC(COLOR_CHANGE, "COLOR_CHANGE", "color");
  ASSOC(COLOR_SCALE_METHOD, "COLOR_SCALE_METHOD", "color");
  ASSOC(COLOR_SCALE_MIDPOINT, "COLOR_SCALE_MIDPOINT", "color");
  ASSOC(COLOR_SCALE_MIN, "COLOR_SCALE_MIN", "color");
  ASSOC(COLOR_SCALE_MAX, "COLOR_SCALE_MAX", "color");

  ASSOC(DISP_RESHAPE, "DISP_RESHAPE", "display");
  ASSOC(DISP_RESETVIEW, "DISP_RESETVIEW", "display");
  ASSOC(DISP_STEREO, "DISP_STEREO", "display");
  ASSOC(DISP_PROJ, "DISP_PROJ", "display");
  ASSOC(DISP_EYESEP, "DISP_EYESEP", "display");
  ASSOC(DISP_FOCALLEN, "DISP_FOCALLEN", "display");
  ASSOC(DISP_LIGHT_ON, "DISP_LIGHT_ON", "display");
  ASSOC(DISP_LIGHT_HL, "DISP_LIGHT_HL", "display");
  ASSOC(DISP_LIGHT_ROT, "DISP_LIGHT_ROT", "display");
  ASSOC(DISP_CLIP, "DISP_CLIP", "display");
  ASSOC(DISP_DEPTHCUE, "DISP_DEPTHCUE", "display");
  ASSOC(DISP_ANTIALIAS, "DISP_ANTIALIAS", "display");
  ASSOC(DISP_SCRHEIGHT, "DISP_SCRHEIGHT", "display");
  ASSOC(DISP_SCRDIST, "DISP_SCRDIST", "display");
  ASSOC(DISP_DETAIL, "DISP_DETAIL", "detail");
  ASSOC(DISP_ALTDETAIL, "DISP_ALTDETAIL", "display");
  ASSOC(DISP_DEPTHSORT, "DISP_DEPTHSORT", "display");
  ASSOC(DISP_UPDATE, "DISP_UPDATE", "display");


  ASSOC(CMD_AXES, "CMD_AXES", "axes");
  ASSOC(CMD_STAGE, "CMD_STAGE", "stage");

  ASSOC(EXTERNAL_START, "EXTERNAL_START", "external");
  ASSOC(EXTERNAL_END, "EXTERNAL_END", "external");
  ASSOC(LABEL_ADD, "LABEL_ADD", "label");
  ASSOC(LABEL_LIST, "LABEL_LIST", "label");
  ASSOC(LABEL_SHOW, "LABEL_SHOW", "label");
  ASSOC(LABEL_DELETE, "LABEL_DELETE", "label");
  ASSOC(LABEL_GRAPH, "LABEL_GRAPH", "label");

  ASSOC(MENU_SHOW, "MENU_SHOW", "menu");
  ASSOC(MENU_MOVE, "MENU_MOVE", "menu");
  ASSOC(MENU_LOC, "MENU_LOC", "menu");

  ASSOC(MOL_NEW, "MOL_NEW", "molecule");
  ASSOC(MOL_LIST, "MOL_LIST", "molecule");
  ASSOC(MOL_DEL, "MOL_DEL", "molecule");
  ASSOC(MOL_ACTIVE, "MOL_ACTIVE", "molecule");
  ASSOC(MOL_FIX, "MOL_FIX", "molecule");
  ASSOC(MOL_ON, "MOL_ON", "molecule");
  ASSOC(MOL_TOP, "MOL_TOP", "molecule");
  ASSOC(MOL_SELECT, "MOL_SELECT", "molecule");
  ASSOC(MOL_REP, "MOL_REP", "molecule");
  ASSOC(MOL_COLOR, "MOL_COLOR", "molecule");
  ASSOC(MOL_ADDREP, "MOL_ADDREP", "molecule");
  ASSOC(MOL_MODREP, "MOL_MODREP", "molecule");
  ASSOC(MOL_DELREP, "MOL_DELREP", "molecule");
  ASSOC(MOL_MODREPITEM, "MOL_MODREPITEM", "molecule");

  ASSOC(MOUSE_MODE, "MOUSE_MODE", "mouse");
  ASSOC(PICK_START, "PICK_START", "pick");
  ASSOC(PICK_MOVE, "PICK_MOVE", "pick");
  ASSOC(PICK_END, "PICK_END", "pick");

  ASSOC(REMOTE_INIT, "REMOTE_INIT", "remote");
  ASSOC(REMOTE_CANCEL, "REMOTE_CANCEL", "remote");
  ASSOC(REMOTE_LIST, "REMOTE_LIST", "remote");
  ASSOC(REMOTE_NEW, "REMOTE_NEW", "remote");
  ASSOC(REMOTE_ATTACH, "REMOTE_ATTACH", "remote");
  ASSOC(REMOTE_RUN, "REMOTE_RUN", "remote");
  ASSOC(REMOTE_SETOPT, "REMOTE_SETOPT", "remote");
  ASSOC(REMOTE_READOPT, "REMOTE_READOPT", "remote");
  ASSOC(REMOTE_WRITEOPT, "REMOTE_WRITEOPT", "remote");
  ASSOC(REMOTE_CHANGE_SETTING, "REMOTE_CHANGE_SETTING", "remote");

  ASSOC(RENDER, "RENDER", "render");
  ASSOC(RENDERLIST, "RENDERLIST", "render");

  ASSOC(SIGMA_EVENT, "SIGMA_EVENT", "sigma");

  ASSOC(SIM_SETPARAM, "SIM_SETPARAM", "simulation");
  ASSOC(SIM_PATCHDISP, "SIM_PATCHDISP", "simulation");
  ASSOC(SIM_TOP, "SIM_TOP", "simulation");
  ASSOC(SIM_DETACH, "SIM_DETACH", "simulation");
  ASSOC(SIM_KILL, "SIM_KILL", "simulation");
  ASSOC(SIM_LIST, "SIM_LIST", "simulation");

  ASSOC(TOOL_INFO, "TOOL_INFO", "tool");
  ASSOC(TOOL_SIZE, "TOOL_SIZE", "tool");
  ASSOC(TOOL_OFFSET, "TOOL_OFFSET", "tool");
  ASSOC(TOOL_PUSH, "TOOL_PUSH", "tool");
  ASSOC(TOOL_POP, "TOOL_POP", "tool");
  ASSOC(TOOL_REPLACE, "TOOL_REPLACE", "tool");
  ASSOC(TOOL_BUTTON, "TOOL_BUTTON", "tool");
  ASSOC(TOOL_COMMAND, "TOOL_COMMAND", "tool");

  ASSOC(TRACKER_START, "TRACKER_START", "tracker");
  ASSOC(TRACKER_PAUSE, "TRACKER_PAUSE", "tracker");
  ASSOC(TRACKER_LIST, "TRACKER_LIST", "tracker");
  ASSOC(TRACKER_LIST_AVAIL, "TRACKER_LIST_AVAIL", "tracker");
  ASSOC(TRACKER_LOC, "TRACKER_LOC", "tracker");
  ASSOC(TRACKER_UNPAUSE, "TRACKER_UNPAUSE", "tracker");
  ASSOC(TRACKER_SETPOS, "TRACKER_SETPOS", "tracker");
  ASSOC(TRACKER_MODPOS, "TRACKER_MODPOS", "tracker");
  ASSOC(TRACKER_SETORIENT, "TRACKER_SETORIENT", "tracker");
  ASSOC(TRACKER_MODORIENT, "TRACKER_MODORIENT", "tracker");

  ASSOC(USER_MENU_ADD, "USER_MENU_ADD", "popup");
  ASSOC(USER_MENU_LIST, "USER_MENU_LIST", "popup");

  if (i != Command::TOTAL) {
    msgWarn << "Incorrect parameter count in Command::Command" << sendmsg;
    msgWarn << "Should be " << Command::TOTAL << " but really is "
	    << i << sendmsg;
  }
}

//////////////////////////////////  constructor
Command::Command(Cmdtype newtype, int newUIid) {
  mytype = newtype;
  UIid = newUIid;
  memset(cmdtextbuf, 0, 256);
  cmdText = new ostrstream(cmdtextbuf, 256);
  textExists = FALSE;
  hasTextCmd = TRUE;

  static first_time = 1;
  if (first_time) {
    first_time = 0;
    do_command_initialization();
  }
}


//////////////////////////////////  destructor
Command::~Command(void) {
  delete cmdText;
}


///////////////////////////////  private routines  /////////////////////////

// creates text equiv, if necessary
void Command::check_and_create_text(void) {
  if(!textExists) {
    create_text();
    textExists = TRUE;
  }
}


///////////////////////////////  protected routines  /////////////////////////

// virtual function to allow each object to do a different action.
// called by 'execute'.
// By default, does nothing.
int Command::do_execute(void) { return TRUE; }


// virtual function which is called when a text version of the command
// must be created to be printed to the console or a log file.  If a
// special version is not provided, this just creates an empty string.
void Command::create_text(void) {
  // by default, just create an empty string and indicate this command
  // does NOT have a text equivalent that should be printed to a log file
  *cmdText << ends;
  hasTextCmd = FALSE;
}


////////////////////////////////  public routines  ///////////////////////////

// return whether this command has a text equivalent
int Command::has_text(void) {
  // need to construct the string if it has not been done so yet
  check_and_create_text();
  return hasTextCmd;
}


// return return string with command text
char *Command::text(void) {
  // need to construct the string if it has not been done so yet
  check_and_create_text();
  return cmdtextbuf;
}


// Do the action specified for this command.  Return success.
int Command::execute(void) {
  MSGDEBUG(3,"Executing: '" << *this << "' ..." << sendmsg);
  return do_execute();
}

