/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/
/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: CoorCRD.h,v $
 *      $Author: ulrich $        $Locker:  $                $State: Exp $
 *      $Revision: 1.1 $      $Date: 1997/03/20 04:16:48 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************/


#ifndef CRDCOORFILE_H
#define CRDCOORFILE_H

#include "CoorFile.h"
class BaseMolecule;


// CRD input object

class ICoorCRD : public ICoorFile {

public:
  // file type enum
  enum CRDTYPE { ASCII, BINARY };
  int boxInfo;
  
private:
  // molecule from which to take structure info
  BaseMolecule *mol;  

  FILE *file;

  // type of file, ascii or binary
  CRDTYPE fileType;
  
  // file number, if file is opened as binary
  int fileNum;
  
  // timestep size (in ps)
  double timeStep;
  
  // starting frame, and frameskip (# timesteps between each frame write)
  int frameStart, frameSkip;
  
  // temp read buffer
  float *X, *Y, *Z;
  
  // free-atom list data
  int namnf, *freeatoms;

public:
  // constructor/destructor: BaseMolecule
  ICoorCRD(BaseMolecule *);
  virtual ~ICoorCRD(void);

  // initialization routine.  Must be called before reading/writing any frames.
  // return TRUE if the file was properly initialized.
  virtual int init(char *);

  // read the next set of coordinates; return list of positions, or NULL if
  // error
  virtual Timestep *read(void);

  //
  // ICoorCRD-specific routines
  //

  // skip over the next set of coordinates; return success
  int skip(void);
 
  // return format of input file
  int file_type(void) { return fileType; }
  
  // return size of timestep (in ps)
  double timestep(void) { return timeStep; }
  
  // frame skip, and starting frame
  int frameskip(void) { return frameSkip; }
  int startframe(void) { return frameStart; }
};

// CRD output object

class OCoorCRD : public OCoorFile {

public:
  enum CRDTYPE {ASCII, BINARY};
  int boxInfo;

private:
  BaseMolecule *mol;
  FILE *file;

  // type of file, ascii or binary
  CRDTYPE fileType;

  // file number, if file is opened as binary
  int fileNum;

  // timestep size (in ps)
  double timeStep;

  // starting frame, and frameskip (# timesteps between each frame write)
  int frameStart, frameSkip;

   // temp read buffer
   float *X, *Y, *Z;

public:
 // constructor/destructor: BaseMolecule,
 // type of output file (ascii or binary), and number
 // of frames to write (if > 0).
 OCoorCRD(BaseMolecule *, CRDTYPE, int = 0);
 virtual ~OCoorCRD(void);
 virtual int init(char *);

 virtual int write(Timestep *);
 int file_type(void) { return fileType; }

 // change the output file type, if file has not been opened yet.  Returns
 // type of file.
 int set_type(CRDTYPE typ) { if(!opened()) fileType = typ; return fileType; }

 // change the number of frames to write, if file is not yet open.  Returns
 // total number of frames to write.
     int set_frames(int f) { if(!opened()) nFrames = f; return nFrames; }

 // change the timestep size, if file is not yet open. Return timestep.
   float set_timestep(double f) { if(!opened()) timeStep = f; return timeStep; }

 // change frame skip, and starting frame.  Return values of parameters.
   int set_frameskip(int f) { if(!opened()) frameSkip = f; return frameSkip; }
     int set_startframe(int f) { if(!opened()) frameStart = f; return frameStart;}};





#endif

