/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: CoorFileData.h,v $
 *	$Author: ulrich $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1997/03/20 05:09:18 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Contains data needed to read and write a coordinate file from a Molecule
 * class.  Will open the file upon creation, and signal if file is OK to
 * read or write.
 *
 ***************************************************************************/
#ifndef COORFILEDATA_H
#define COORFILEDATA_H

#include "CoorFile.h"
class Molecule;
class Timestep;


class CoorFileData {

public:
  // type of coordinate files we understand
  enum CoorFiles { PDB, DCD, CRD,COORTYPES, UNKNOWN };

  // characteristics for file
  char *name;		// name of coordinate file
  int type;		// what kind is this?  (one of CoorFiles types)
  int is_input;		// is this an input or output file?
  int begFrame;		// first frame to keep (frames numbered 0 ... end-1)
  int endFrame;		// last frame to keep; if < 0, keep all frames
  int frameSkip;	// keep every frameSkipth frame (i.e. if 2, keep 0,2,4)
  int recentFrame;	// most recent frame written.

  // pointers for either an input or an output file
  ICoorFile *inf;	// input file object pointer, if is_input == T
  OCoorFile *outf;	// output file object pointer, if is_input == F

  // which molecule we're to use for data
  Molecule *mol;

  // have we opened the file successfully?
  int opened;

public:
  CoorFileData(Molecule *, char *n, int t, int inp, int bf, int ef, int fs);
  ~CoorFileData(void);
  
  // perform next operation, either read or write.  Return pointer to
  // timestep read/written, or NULL if done.
  Timestep *next(void);
};

// string names for the different coordinate file types (identified by
// their file extension)
extern char *CoorFileSuffix[CoorFileData::COORTYPES + 1];
extern char *CoorFileDesc[CoorFileData::COORTYPES + 1];

#endif

