/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: DrawMolItemSurface.C,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/09/07 23:19:16 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * This contains the surface code for DrawMolItem
 *
 * The surfaces are made with SURF, an external program.  It was
 * written by Amitabh Varshney when he was at UNC.  The code is
 * available from ftp.cs.unc.edu .
 ***************************************************************************/



#include <stdio.h>
#include <stdlib.h>
#include "DrawMolecule.h"
#include "DrawMolItem.h"
#include "utilities.h"
#include "Surf.h"

// In general, the method is
//    write the file for surf input
//    call surf
//    read the triangles
//    write them to the draw list

void DrawMolItem::draw_surface(float *framepos)
{
   int count = 0; // count is number of atoms selected
   // mapping from order printed out (selected) to atom id
   int *map = new int[mol->nAtoms];
   float radius = atomRep->sphere_rad();
   
   if (atomRep -> surf == NULL ||
       needRegenerate & FORCE_REGEN ||
       needRegenerate & SEL_REGEN ||
       needRegenerate & REP_REGEN) {
      // then I need to recalculate the SURF
      float *x = new float[mol->nAtoms];
      float *y = new float[mol->nAtoms];
      float *z = new float[mol->nAtoms];
      float *r = new float[mol->nAtoms];

      // check all the atoms if they are displayed, and if so, get
      // the data for it
      for (int i=0; i<mol->nAtoms; i++) {
	 if (atomSel->on[i]) {
	    map[count] = i;
	    r[count] = mol->atom(i) -> radius();
	    x[count] = framepos[3*i+0];
	    y[count] = framepos[3*i+1];
	    z[count] = framepos[3*i+2];
	    count ++;
	 }
      }
      // make the new surface
      atomRep->set_surf(new Surf(radius, count, r, x, y, z));
      if (!atomRep->surf->is_okay) {
	 atomRep -> delete_surf();
      }
      delete [] r;
      delete [] x;
      delete [] y;
      delete [] z;
   } else { // recreate the mapping
      for (int i=0; i<mol->nAtoms; i++) {
	 if (atomSel->on[i]) {
	    map[count++] = i;
	 }
      }
   }

   // reset the changed field ('cause I just used it)
   atomRep -> option_changed = FALSE;
   // and display everything
   if (atomRep->surf && atomRep->surf->triangles.num() > 0) {
      cmdMaterials.putdata(TRUE, this);
      int the_color = -1; // nothing can be this
      int new_color;
      for (int i=0; i<atomRep->surf->triangles.num(); i++) {
	 new_color = atomColor ->
	      color[map[atomRep->surf->triangles[i].index]];
	 if (new_color != the_color) {
	    cmdColorIndex.putdata(new_color, this);
	    new_color = the_color;
	 }
	 // and draw the triangle
	 cmdTriangle.putdata(atomRep->surf->triangles[i].point[0].pos,
			     atomRep->surf->triangles[i].point[1].pos,
			     atomRep->surf->triangles[i].point[2].pos,
			     atomRep->surf->triangles[i].point[0].norm,
			     atomRep->surf->triangles[i].point[1].norm,
			     atomRep->surf->triangles[i].point[2].norm,
			     this);
      }
      delete [] map;
   }
   msgInfo << "Done." << sendmsg;
}




