/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: DrawMolecule.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.13 $	$Date: 1995/11/15 04:29:29 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Displayable version of a DrawMolecule, derived from BaseMolecule and
 * Displayable3D.  This contains all the info for rendering
 * the molecule.
 *
 ***************************************************************************/
#ifndef DRAWMOLECULE_H
#define DRAWMOLECULE_H

#include "BaseMolecule.h"
#include "Displayable.h"
#include "DrawMolItem.h"
#include "ResizeArray.h"
#include "DispCmds.h"
class AtomColor;
class AtomRep;
class AtomSel;


class DrawMolecule : public BaseMolecule, public Displayable3D {

public:
  // is this molecule active?  Used by MoleculeList.
  int active;

  // routine to set the name of the molecule
  virtual void set_name(char *);
  
private:
  // does this molecule require a redraw during the prepare phase?
  int needRedraw;
  
  // representations
  ResizeArray<DrawMolItem *> repList;

protected:
  // regenerate the command list
  virtual void create_cmdlist(void);

private:
  // useful drawing commands
  DispCmdData dataCmd;		// put in block of data with coordinates
  DispCmdText cmdTxt;
  DispCmdMaterials cmdMaterials;
  DispCmdLineWidth cmdLineWidth;
  DispCmdColorIndex cmdCol;
  DispCmdLineIndex cmdLine;

public:
  // constructor ... nothing to specify.  Must be given either a Scene
  // or another Displayable
  DrawMolecule(Scene *);
  DrawMolecule(Displayable *);
  virtual ~DrawMolecule(void);
  
  // create the molecule.  Successive classes should call their parent 'create'
  // after they are done.
  // Returns success .... if not successful, should be 'delete'ed
  virtual int create(void);

  //
  // public utility routines
  //
  
  // return whether the Nth atom is displayed.  This is true if ANY
  // representation is displaying the given atom
  int atom_displayed(int);

  //
  // public virtual routines for Displayable
  //
  
  // Create a popup menu, with the given name; return NULL if none available
  // subclasses should have the parent first create a menu, and then add items
  // to the end of it.  By default, this does nothing and returns NULL.
  // 1st argument is the tag of the item selected (it should correspond to
  // a tag from this object).
  virtual PopupMenu *create_popup_menu(int);

  // prepare for drawing ... do any updates needed right before draw.
  //  ... this updates the animation
  virtual void prepare(DisplayDevice *);

  //
  // access routines for the drawn molecule components (which are the children)
  //
  
  // total number of components
  int components(void) { return repList.num(); }
  
  // return Nth component ... change to proper return type
  DrawMolItem *component(int);

  // delete the Nth representation ... return success
  int del_rep(int);

  // add a new representation (component) ... return success
  virtual int add_rep(AtomColor *, AtomRep *, AtomSel *);

  // change the Nth representation ... return success.
  // if any object is NULL, that characteristic is not changed.
  virtual int change_rep(int, AtomColor *, AtomRep *, AtomSel *);

  // force a recalculation of the Nth representation, return success
  virtual int force_recalc(int n);
  // force a recalc of all representations
  virtual void force_recalc(void);

};

#endif

