/***************************************************************************
 *cr
 *cr		(C) Copyright 1995 The Board of Trustees of the
 *cr			    University of Illinois
 *cr			     All Rights Reserved
 *cr
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile$
 *	$Author: leech $			$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $			$Date: 96/11/22 02:54:53 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A child Displayable component for a MoleculeSigma. DrawTugs contains
 *  a list of tugs (SIgMA postition well restraints) applied to the
 *  molecule by SIgMA. It manages creating, destroying, modifying,
 *  displaying tugs as well as sending them to SIgMA to maintain a
 *  consistent model by both programs. DrawTugs is loosely based on
 *  Andrew's DrawForce class which serves a similar function for NAMD.
 *
 ***************************************************************************/
#ifndef DRAWTUGS_H
#define DRAWTUGS_H

// These are like MSGDEBUG in Inform.h, but always compiled in
//  regardless of VMDDEBUG.
#define GUIDEBUG(level,msg) { msgInfo << msg; }
#define SIGMADEBUG(level,msg) { msgDebug.msg_level(level) << msg; }

#include "Displayable.h"
#include "DispCmds.h"
#include <mdio/global.h>
#include <mdio/Communication.h>

// Map a pick motion to object space
void map_pick_move(DisplayDevice *, Matrix4 &, int, float *, float *, float *);

class DrawMolecule;
class MoleculeSigma;

extern void send_tug_event(int event, TugInfo *t);

class DrawTugs : public Displayable3D {
private:
    // parent molecule
    DrawMolecule *mol;

    // Sigma component of parent molecule
    MoleculeSigma *sigma;

    // The tugs being displayed by the DrawTugs displayable
    ResizeArray<TugInfo> *tugs;

    // useful drawing command objects, used to create display list
    DispCmdColorIndex cmdColorIndex;
    DispCmdLine cmdLine;
    DispCmdMaterials cmdMaterials;
    DispCmdLineType cmdLineType;
    DispCmdLineWidth cmdLineWidth;
    DispCmdPickPoint pickPoint;
    DispCmdCone cmdCone;

    // regenerate the command list
    void create_cmdlist(void);

    // do we need to completely redraw the list?
    int needRegenerate;

    // color category we're using for our colors
    int colorCat;

    // Pick mode index for the Sigma Tugs pick mode
    int tugPickMode;

    // Currently picked tug, identified by its tug_id field
    // We don't keep an index into the (*tugs) array because
    //	the contents of that array could change during picking
    //	if other tugs are added or removed somehow.
    int cur_tug_id;

 protected:
    //
    // virtual functions used to act as a ColorUser object
    //

    // virtual function which is called when a new colorlist is provided.
    // may not need to do anything, which is the default cause
    virtual void do_use_colors(void);

    // do action due to the fact that a color for the given ColorList for
    // the specified category has changed
    virtual void do_color_changed(ColorList *, int);

    //
    // protected virtual function used to act as a Pickable object
    //

    // creates a new pick mode of a type specified by the code integer argument.
    // this is typically only used by add_pick_mode; the code is both defined
    // by and used by the derived class
    virtual PickMode *create_pick_mode(int);

 public:
    // constructor: parent molecule, Sigma component of parent,
    //	pick mode we're interested in
    DrawTugs(DrawMolecule *, MoleculeSigma *, int);
    ~DrawTugs();

    //
    // public virtual routines
    //

    // prepare for drawing ... do any updates needed right before draw.
    virtual void prepare(DisplayDevice *);

    //
    // protected virtual function used to act as a Pickable object
    //

    // return if we are interested in the given pick mode or not
    virtual int want_pick_mode(int);

    // return whether the pickable object is being displayed
    virtual int pickable_on(void);

    // Return pointer to the tug with the specified ID
    TugInfo *find_tug_from_id(int, int * = NULL);

    // called when a pick is begun/moves/ends
    //	  args = display to use, obj picked, button, mode, tag, dim, pos
    // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
    // For 3D version: x,y,z are transformed position of pointer
    virtual void pick_start(DisplayDevice *, Pickable *,
				  int, int, int, int, float *);
    virtual void pick_move(DisplayDevice *, Pickable *,
				  int, int, int, int, float *);
    virtual void pick_end(DisplayDevice *, Pickable *,
				  int, int, int, int, float *);

    // Add a new tug to VMD and Sigma; return its ID
    int add_tug(int tug_id, const float *, float);

    // Modify position of an existing tug given its ID
    void move_tug(int tug_id, const float *);

    // Finish modifying a tug given its ID
    void finalize_tug(int tug_id);

    // Remove an existing tug given its ID
    void remove_tug(int tug_id);

    // List tugs known to VMD
    void list_tugs(int id = -1);
};

#endif

