/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: EditFormsObj.C,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.5 $	$Date: 1995/09/08 19:51:37 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The on-screen menu to edit the animation lists of molecules.
 *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include "EditFormsObj.h"
#include "CmdAnimate.h"
#include "MoleculeList.h"
#include "Global.h"

// actions we can take here: read, write, delete
#define ACTION_READ	0
#define ACTION_WRITE	1
#define ACTION_DELETE	2
#define ACTION_TOTAL	3

// amount specifiers
#define AMOUNT_ALL	0
#define AMOUNT_SELECT	1
#define AMOUNT_TOTAL	2


/////////////////////////  constructor  
EditFormsObj::EditFormsObj(UIList *uil, CommandQueue *cq,
	int sh,int bd,int *npos) : FormsObj("edit", uil, cq, bd, npos) {
	
  // set values of common menu elements
  form = editMenu;
  lightButton = edit_menu_button;
  offButton = edit_menu_off;
  
  // turn on if required
  if(sh)
    On();
}

/////////////////////////  private routines  

// reset the form to a particular animation action
void EditFormsObj::reset_action(int newaction) {
  freeze();
    fl_set_choice(edit_action, newaction + 1);
    if(newaction == ACTION_READ) {
      fl_show_object(edit_read);
      fl_show_object(edit_file_type);
    } else
      fl_hide_object(edit_read);
    if(newaction == ACTION_WRITE) {
      fl_show_object(edit_write);
      fl_show_object(edit_file_type);
    } else
      fl_hide_object(edit_write);
    if(newaction == ACTION_DELETE) {
      fl_show_object(edit_delete);
      fl_hide_object(edit_file_type);
    } else
      fl_hide_object(edit_delete);
  unfreeze();
}


// reset the form to a particular amount
void EditFormsObj::reset_amount(int newamount) {
  freeze();
    fl_set_choice(edit_amount, newamount + 1);
    if(newamount == AMOUNT_ALL) {
      fl_hide_object(edit_begin);
      fl_hide_object(edit_end);
      fl_hide_object(edit_skip);
    }
    if(newamount == AMOUNT_SELECT) {
      fl_show_object(edit_begin);
      fl_show_object(edit_end);
      fl_show_object(edit_skip);
    }
  unfreeze();
}


//////////////////////  protected virtual routines  

// routine to check the main form for use
int EditFormsObj::check(FL_OBJECT *obj) {

  if(obj == edit_mol) {
    if(fl_get_choice(obj) > 0)
      mol = moleculeList->molecule(fl_get_choice(obj) - 1);
    else
      mol = NULL;

  } else if(obj == edit_action) {
    reset_action(fl_get_choice(obj) - 1);

  } else if(obj == edit_amount) {
    reset_amount(fl_get_choice(obj) - 1);
    
  } else if(obj == edit_begin || obj == edit_end || obj == edit_skip ||
  		obj == edit_file_type) {
    // do nothing
    
  } else if(obj == edit_read || obj == edit_write || obj == edit_delete) {
    if(mol) {
      int bf = (-1), ef = (-1), fs = (-1);
      if(fl_get_choice(edit_amount) - 1 == AMOUNT_SELECT) {
        bf = (int) fl_get_counter_value(edit_begin);
        ef = (int) fl_get_counter_value(edit_end);
        fs = (int) fl_get_counter_value(edit_skip);
      }
    
      if(obj == edit_delete) {
        // delete specified frames
        addcommand(new CmdAnimDelete(mol->id(), bf, ef, fs, id()));
      } else {
        // read/write data ... get filename first
        char *fname = NULL;
        char *prompt = "Select file with molecule coordinates:";
        int filetype = fl_get_choice(edit_file_type) - 1;
        if(filetype == CoorFileData::PDB)
	  fname = (char *) fl_show_fselector(prompt, "","*.pdb","");
        else
	  fname = (char *) fl_show_fselector(prompt, "","*","");
	
        // if filename given, read/write file
        if(fname) {
          if(obj == edit_read)
	    addcommand(new CmdAnimReadFile(mol->id(), fname, filetype, bf, ef,
	  	  	fs, id()));
	  else
	    addcommand(new CmdAnimWriteFile(mol->id(), fname, filetype, bf, ef,
	  		fs, id()));
        }
      }
    }

  } else
    return FALSE;

  return TRUE;
}


// do form-specific acting on commands.  Return whether
// any action was taken on this command.
// Arguments are the command type, command object, and the 
// success of the command (T or F).
int EditFormsObj::forms_act_on_command(int, Command *, int) {
  // nothing to do here at all ...
  return FALSE;
}


//////////////////////  public virtual routines  

// initialize the user interface
void EditFormsObj::init(void) {
  int i;

  freeze();
    // set all the basic values for controllers, etc
    fl_set_counter_bounds(edit_begin, -1.0, 100000.0);
    fl_set_counter_bounds(edit_end, -1.0, 100000.0);
    fl_set_counter_bounds(edit_skip, -1.0, 100000.0);
    fl_set_counter_step(edit_begin, 1.0, 10.0);
    fl_set_counter_step(edit_end, 1.0, 10.0);
    fl_set_counter_step(edit_skip, 1.0, 10.0);
    fl_set_counter_precision(edit_begin, 0);
    fl_set_counter_precision(edit_end, 0);
    fl_set_counter_precision(edit_skip, 0);
    fl_set_counter_value(edit_begin, -1.0);
    fl_set_counter_value(edit_end, -1.0);
    fl_set_counter_value(edit_skip, -1.0);

    // initialize choosers
    fl_clear_choice(edit_action);
    fl_addto_choice(edit_action, "Read File");
    fl_addto_choice(edit_action, "Write File");
    fl_addto_choice(edit_action, "Delete Frames");
    
    fl_clear_choice(edit_amount);
    fl_addto_choice(edit_amount, "All");
    fl_addto_choice(edit_amount, "Selected");
    
    fl_clear_choice(edit_file_type);
    for(i=0; i < CoorFileData::COORTYPES; i++)
      fl_addto_choice(edit_file_type, CoorFileSuffix[i]);

    // set state of form initially
    reset_action(ACTION_READ);
    reset_amount(AMOUNT_ALL);

    // do a reset to set initial values for molecule selection
    reset();

  unfreeze();
}


// reset the user interface
void EditFormsObj::reset(void) {
  freeze();
    fl_clear_choice(edit_mol);
    for(int i=0; i < moleculeList->num(); i++)
      fl_addto_choice(edit_mol, (moleculeList->molecule(i))->name);
    mol = moleculeList->top();
    if(mol)
      fl_set_choice(edit_mol, moleculeList->mol_index_from_id(mol->id()) + 1);
  unfreeze();
}

