/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: Enterprise.h,v $
 *      $Author: billh $        $Locker:  $                $State: Exp $
 *      $Revision: 1.3 $      $Date: 1995/05/11 22:45:57 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  A figure which looks somewhat like the NCC 1701 Enterprise
 *
 ***************************************************************************/
#ifndef ENTERPRISE_H
#define ENTERPRISE_H

#include "Displayable.h"
#include "DispCmds.h"

class Enterprise : public Displayable3D {

private:
  // lines defining the Enterprise
//   _________________     ________________
//  |_________________|   |________________|
//      ________| |______/_/       
//     |                  |.   (the . is the origin)
//     |__________________|
//
  float hullStart[3], hullEnd[3]; float hullRadius;

  float nacelleRadius;
// float nacelleSupportRadius;  // supports not (yet) done
  float nacelle1Start[3], nacelle1End[3];
  float nacelle2Start[3], nacelle2End[3];

//  float saucerSupportRadius;
//  float saucerSupportStart[3], saucerSupportEnd[3];

  float saucerRadius;
   float saucerStart[3], saucerEnd[3];

  void create_cmdlist( void);
  
public:
  // constructor; the Scene to register this with
  Enterprise(Scene *);
  
  // prepare to drawing
  virtual void prepare(DisplayDevice *);

};

#endif /* ENTERPRISE_H */

