/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: FileRenderList.C,v $
 *	$Author: ulrich $	$Locker:  $		$State: Exp $
 *	$Revision: 1.12 $	$Date: 1997/02/21 17:51:04 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The FileRenderList class maintains a list of available FileRenderer
 * objects
 *
 ***************************************************************************/

#include "FileRenderList.h"
#include "R3dDisplayDevice.h"
#include "POVDisplayDevice.h"
#include "POV3DisplayDevice.h"
#include "RayShadeDisplayDevice.h"
#include "RadianceDisplayDevice.h"
#include "ArtDisplayDevice.h"
#include "VrmlDisplayDevice.h"
#include "SnapshotDisplayDevice.h"
#include "TokenDisplayDevice.h"
#include "PSDisplayDevice.h"
#include "STLDisplayDevice.h"


// constructor, start off with the default means of rendering
FileRenderList::FileRenderList(void) {
    add(new R3dDisplayDevice(R3dDisplayDevice::R3D));
    add(new R3dDisplayDevice(R3dDisplayDevice::TKR3D));
    add(new SnapshotDisplayDevice());
    add(new POV3DisplayDevice());
    add(new POVDisplayDevice());
    add(new RayShadeDisplayDevice());
    add(new RadianceDisplayDevice());
    add(new ArtDisplayDevice());
    add (new PSDisplayDevice());
    add (new STLDisplayDevice());
    add(new VrmlDisplayDevice());
    add(new TokenDisplayDevice());
}

// destructor, deallocate all the info
FileRenderList::~FileRenderList(void) {
  for (int i=0;i<renderList.num();i++)
    delete renderList.data(i);
}


// add a new render class with its corresponding name
void FileRenderList::add(FileRenderer *newRenderer) {
  if(newRenderer)
    renderList.add_name(newRenderer->name, newRenderer);
}

// figure out how many render classes are installed
int FileRenderList::num(void) {
  return renderList.num();
}

// return the name for the ith class, returns NULL if out of range
char *FileRenderList::name(int i) {
  if(i>=0 && i < renderList.num()) {
    return renderList.name(i);
  }
  return NULL;
}

// given the name, find the corresponding class (case insensitive search),
// else returns NULL  
FileRenderer *FileRenderList::find(char *rname) {
  int indx = renderList.typecode(rname);
  
  if(indx >= 0)
    return renderList.data(indx);
  else
    return NULL;
}

