/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: FilesFormsObj.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1995/05/11 22:46:05 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The on-screen menu to load a new molecule from a set of files.
 *
 ***************************************************************************/
#ifndef FILESFORMSOBJ_H
#define FILESFORMSOBJ_H

#include "FormsObj.h"


class FilesFormsObj : public FormsObj {

private:
  // select a filename. args are fname input object, file type, and prompt
  void choose_filename(FL_OBJECT *, int, char *);

  // reset the molecule file type based on the given value
  void reset_mol_type(int);

protected:
  // check if the given forms pointer is one for this menu, and generate
  // a command if necessary.  Return 'TRUE' if the pointer is for an object
  // in this menu.
  virtual int check(FL_OBJECT *);

  // do form-specific acting on commands ... no need here
  virtual int forms_act_on_command(int, Command *, int);

public:
  // class constructor and destructor
  FilesFormsObj(UIList *, CommandQueue *, int, int, int * = NULL);

  //
  // virtual routines for UI init/display
  //
  
  // initialize the user interface
  virtual void init(void);
  
  // reset the user interface (forces update of all info displays)
  virtual void reset(void);

  // update the interface display for each screen redraw; only if
  // necessary ... here, not so
  // virtual void update(void);

};

#endif

