/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: GLDisplayDevice.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.12 $	$Date: 1996/05/14 20:04:19 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Subclass of GLRenderer, this object has routines used by all the
 * different display devices that are GL-specific.  Will render drawing
 * commands into a single GL window.
 *
 ***************************************************************************/
#ifndef GLDISPLAYDEVICE_H
#define GLDISPLAYDEVICE_H

#include "GLRenderer.h"

#define GL_STEREO_OFF		0
#define GL_STEREO_CRYSTAL	1
#define GL_STEREO_CRYSTAL_REV	2
#define GL_STEREO_CROSSED	3
#define GL_STEREO_SIDE		4
#define GL_STEREO_LEFT		5
#define GL_STEREO_RIGHT		6
#define GL_STEREO_MODES		7


class GLDisplayDevice : public GLRenderer {

private:
  // id number of the GL window
  long windowID;

protected:
  // create a new window and set it's characteristics
  long open_window(char *, int *, int *);

  //
  // stereo routines and data
  //

  // functions used to set perspective for normal or stereo view
  void set_persp(DisplayEye = NOSTEREO);

public:
  // constructor/destructor
  // arguments are the size and location for the window, if known
  GLDisplayDevice(int *size = NULL, int *loc = NULL);
  virtual ~GLDisplayDevice(void);

  //
  // get the current state of the device's pointer (i.e. cursor if it has one)
  //

  virtual int x(void);		// abs pos of cursor from lower-left corner
  virtual int y(void);		// same, for y direction
  virtual int button_down(int);	// whether a button is currently pressed
  virtual int shift_state(void);// ORed SHIFT/CONTROL/ALT value

  // allow the user to define a special shape for the cursor ... the data
  // is assumed to consist of a single-dim array of 32 unsigned shorts; the
  // first 16 define a 16x16-bit (row-major) pattern, the last 16 are a
  // "second layer" which may be drawn in a different color
  // args: which shape (>0, with 0 the "default" case which cannot be changed)
  // the bitmap data, and the "hot spot" from the lower-left corner
  virtual void change_cursor_shape(int, unsigned short *, int, int);

  // set the Nth cursor shape as the current one.  If no arg given, the
  // default shape (n=0) is used.
  virtual void set_cursor(int = 0);

  // get the current cursor setting
  virtual int get_cursor(void);
  //
  // event handling routines
  //

  // queue the standard events (need only be called once ... but this is
  // not done automatically by the window because it may not be necessary or
  // even wanted)
  virtual void queue_events(void);

  // test if there is an event ready
  virtual int test_events(void);

  // read the next event ... returns an event type (one of the above ones),
  // and a value.  Returns success, and sets arguments.
  virtual int read_event(long &, long &);

  //
  // routines to deal with stereo display
  //
  
  // change to a different stereo mode (0 means 'off')
  virtual void set_stereo_mode(int = 0);

  //
  // virtual routines for preparing to draw, drawing, and finishing drawing
  //
  
  virtual int prepare2D(int do_clear = TRUE);	// ready to draw 2D
  virtual int prepare3D(int do_clear = TRUE);	// ready to draw 3D
  virtual void clear(void);			// erase the device
  virtual void left(void);			// ready to draw left eye
  virtual void right(void);			// ready to draw right eye
  virtual void normal(void);			// ready to draw non-stereo
  virtual void update(int do_update = TRUE);	// finish up after drawing
  virtual void reshape(void);			// refresh device after change
  
};

#endif

