/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: GLRenderer.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.12 $	$Date: 1997/03/24 22:12:23 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Subclass of DisplayDevice, this object has routines used by all the
 * different display devices that are GL-specific.  Will render drawing
 * commands into a single GL window.  This is not the complete definition,
 * however, of a DisplayDevice; something must provide routines to open
 * windows, reshape, clear, set perspective, etc.  This object contains the
 * code to render a display command list.
 *
 ***************************************************************************/
#ifndef GLRENDERER_H
#define GLRENDERER_H

#include <gl.h>
#include <gl/device.h>
#include <math.h>
#include "DisplayDevice.h"
#include "DepthSortObject.h"
#include "SortableArray.h"
#include "FileRenderer.h"

#if !defined(__NPGL__) && !defined(ARCH_AIX3)
#include <gl/sphere.h>
#endif

#define DTOEYE(x,y,z) ( (x-scaledeyePos[0])*(x-scaledeyePos[0]) + \
			(y-scaledeyePos[1])*(y-scaledeyePos[1]) + \
			(z-scaledeyePos[2])*(z-scaledeyePos[2]) )

class GLRenderer : public DisplayDevice {

private:
  // pointer to data block (should be changed to allow for multiple blocks)
  float *dataBlock;

  // Auxilliary pointers to be used in building a depth-sorted list.
  // They capture the present state of the graphics system at the
  // time each object is to be drawn.
  char *sphere_res;
  char *sphere_mode;
  char *line_style;
  char *line_width;
  char *color_index;
  char *material_active;
  float *moredata;
  float scaledeyePos[3];
  SortableArray <DepthSortObject> DepthSortList;
  
  // do we need to turn antialiasing and depth-cueing on when materials
  // are turned off?
  int need_aaon, need_cueon;

  // do we have a currently-defined pop-up menu?
  PopupMenu *mainMenu;

protected:
  // routines to perform various GL-specific graphics operations
  void set_line_width(int);
  void set_line_style(int);
  void set_sphere_res(int);
  void set_sphere_mode(int);
  void triangle(float *x1, float *x2, float *x3, // triangle with normals
		float *n1, float *n2, float *n3);
  void square(float *norm, float *, float *, float *, float *); 
  void square(float *, float *, float *, float *, float *, float *);
  void cylinder(float *, float *, int, float, int filled);  // slow
#ifndef USE_SLOW_CYLINDERS
  void cylinder(int num, float *edges, int filled);  // fast, if precomputed
#endif
  void cone(float *, float *, int, float);
  
  //
  // protected virtual routines
  //
  
  // virtual routines to deal with light sources at device level
  // all return success of operation
  virtual int do_define_light(int n, float *color, float *position);
  virtual int do_activate_light(int n, int turnon);

  // virtual routines to deal with materials at device level
  // all return success of operation
  virtual int do_define_material(int n, float *data);
  virtual int do_activate_material(int n, int turnon);

public:
  // constructor/destructor
  GLRenderer(char *);
  virtual ~GLRenderer(void);

  //
  // virtual routines to affect the device's transformation matrix
  //
  
  virtual void push(void);		// push device's curr state on stack
  virtual void pop(void);		// pop device's curr state from stack
  virtual void loadmatrix(Matrix4 &);	// replace trans matrix w. given one
  virtual void multmatrix(Matrix4 &);	// multiply trans matrix w. given one

  //
  // virtual routines to find characteristics of display itself
  //

  // return absolute 2D screen coordinates, given 2D or 3D world coordinates.
  virtual void abs_screen_loc_3D(float *, long *);
  virtual void abs_screen_loc_2D(float *, long *);

  // size of physical display object
  virtual void screen_size_mm(long &, long &);
  virtual void screen_size_pixel(long &, long &);

  // Given a 3D point (pos A),
  // and a 2D rel screen pos point (for pos B), computes the 3D point
  // which goes with the second 2D point at pos B.  Result returned in B3D.
  virtual void find_3D_from_2D(float *A3D, float *B2D, float *B3D);

  //
  // virtual functions to turn on/off depth cuing and antialiasing
  //
  
  virtual void aa_on(void);
  virtual void aa_off(void);
  virtual void cueing_on(void);
  virtual void cueing_off(void);

  //
  // virtual routines to create and activate a popup (possibly pull-down) menu 
  //

  // given a PopupMenu definition, create it in the window (but do not
  // activate it yet).  Return success.
  virtual int menu_create(PopupMenu *);

  // activate a previously-created menu.  If the windowing system has no
  // current menu, or cannot do this operation, returns (-1); otherwise,
  // returns the return code for the select (-1 if none selected).
  virtual int menu_activate(void);

  // delete the given menu from the display.
  // If no argument is given, deletes the current menu (if any).
  // Returns success.
  virtual int menu_delete(PopupMenu * = NULL);

  //
  // virtual routines for preparing to draw, drawing, and finishing drawing
  //
  
  virtual void render(void *);		/* process list of draw cmds */
  void render_depth_sort (void *);      /* Again, process list of draw
					   commands, but depth sort
					   the objects before drawing */
  virtual void render_done();           /* Call this when doing depth
					   sort rendering to cause
					   actual drawing.  This allows
					   for multiple objects to be
					   correctly displayed in
					   transparent mode. */
  void process_depth_sorted_list();
  void render_token (char *, float *);  /* As it says, this renders
					   just one token passed to it */

};

#endif

