/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: GeometryAngle.C,v $
 *      $Author: dalke $        $Locker:  $                $State: Exp $
 *      $Revision: 1.5 $      $Date: 1995/10/04 07:31:15 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Measures the angle between three atoms, and draws a marker for the angle
 * into the display list for a given Displayable.
 *
 ***************************************************************************/

#include "GeometryAngle.h"
#include "MoleculeList.h"
#include "Molecule.h"
#include "utilities.h"


////////////////////////  constructor  /////////////////////////
GeometryAngle::GeometryAngle(int *m, int *a, MoleculeList *mlist)
	: GeometryMol(3, m, a, mlist) {

}


////////////////////  public virtual routines  //////////////////////

// recalculate the value of this geometry, and return it
float GeometryAngle::calculate(void) {

  // get coords to calculate distance 
  float pos1[3], pos2[3], pos3[3], r1[3], r2[3];
  if(!normal_atom_coord(objIndex[0], comIndex[0], pos1))
    return 0.0;
  if(!normal_atom_coord(objIndex[1], comIndex[1], pos2))
    return 0.0;
  if(!normal_atom_coord(objIndex[2], comIndex[2], pos3))
    return 0.0;

  subtract(r1, pos1, pos2);
  subtract(r2, pos3, pos2);
  return(geomValue = angle(r1, r2));
}


// draw the geometry marker in the given Displayable's drawing list
void GeometryAngle::draw_marker(Displayable *d) {
  char valbuf[32];

  // get the transformed positions, and draw a line between them
  float pos1[3], pos2[3], pos3[3];
  if(!transformed_atom_coord(objIndex[0], comIndex[0], pos1))
    return;
  if(!transformed_atom_coord(objIndex[1], comIndex[1], pos2))
    return;
  if(!transformed_atom_coord(objIndex[2], comIndex[2], pos3))
    return;

  // draw a line into the given Displayable
  display_line(pos1, pos2, d);
  display_line(pos2, pos3, d);
  
  // print value of distance at midpoint
  midpoint(valuePos, pos1, pos3);
  midpoint(valuePos, valuePos, pos2);
  sprintf(valbuf, "%7.2f", geomValue);
  display_string(valbuf, d);

}

int GeometryAngle::sets_pick(void) { return TRUE; }

void GeometryAngle::set_pick(void) {
  // set the Tcl values
  if (objIndex[0] == objIndex[1] && objIndex[1] == objIndex[2]) {
    set_pick_selection(objIndex[0], 3, comIndex);
  } else {
    set_pick_selection();
  }
  set_pick_value(geomValue);
}

