/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MDCommUserCommands.C,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/12/01 16:19:17 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 *   Interface to control the remote simulation
 *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include <rapp.h>
#include "mdcomm.h"
#include "MDCommUserCommands.h"

//////////////////////////////// send simple force vectors 

void  mdcomm_transfer_vmdForceData(int, int*, float*,int);

#define SIMPLE_SEND(tag, pointer, size, type, msg)                        \
if (rapp_send(handle->appd_sock, tag, pointer, size, type) == -1) {       \
  fprintf(stderr, "mdcomm_send_force_cmd: couldn't send " msg);           \
  fflush(stderr);                                                         \
  return -1;                                                              \
}

int mdcomm_send_force_cmd(rapp_client_handle_t handle, int n, 
			  int *indicies, float *fx, float *fy, float *fz)
{
  if (!handle) return 0;
  if (rapp_begin_user_command(handle, MDCOMM_FORCE_CMD) != 0) {
    fprintf(stderr, "mdcomm_send_force_cmd: couldn't start user command\n");
    fflush(stderr);
    return -1;
  }
  SIMPLE_SEND(MDCOMM_FORCE_CMD, &n, sizeof(n), RAPP_INT, "size");
  SIMPLE_SEND(MDCOMM_FORCE_CMD, indicies, n*sizeof(int), RAPP_INT, 
	      "indicies");
  SIMPLE_SEND(MDCOMM_FORCE_CMD, fx, n*sizeof(float), RAPP_FLOAT, "x forces");
  SIMPLE_SEND(MDCOMM_FORCE_CMD, fy, n*sizeof(float), RAPP_FLOAT, "y forces");
  SIMPLE_SEND(MDCOMM_FORCE_CMD, fz, n*sizeof(float), RAPP_FLOAT, "z forces");

  return 0;
}

int mdcomm_appd_force_cmd(rapp_active_socket_t *insock,
                          rapp_active_socket_t *outsock)
{
  int tag;
  int n;
  int *indicies;
  float *fx, *fy, *fz;
  /* get the number of elements */
  rapp_recv(insock, &tag, &n, RAPP_INT);

  /* make room for them */
  indicies = (int *)   malloc(n * sizeof(int));
  fx = (float *) malloc(3 * n * sizeof(float));
  fy = fx + n;
  fz = fy + n;

  /* get the indicies */
  rapp_recv(insock, &tag, indicies, RAPP_INT);
  /* get the x forces */
  rapp_recv(insock, &tag, fx, RAPP_FLOAT);
  /* get the y forces */
  rapp_recv(insock, &tag, fy, RAPP_FLOAT);
  /* get the z forces */
  rapp_recv(insock, &tag, fz, RAPP_FLOAT);

  /* and send them out */
  rapp_send(outsock, MDCOMM_FORCE_CMD, &n, sizeof(n), RAPP_INT);
  rapp_send(outsock, MDCOMM_FORCE_CMD, indicies, n*sizeof(int), RAPP_INT);
  rapp_send(outsock, MDCOMM_FORCE_CMD, fx, n*sizeof(float), RAPP_FLOAT);
  rapp_send(outsock, MDCOMM_FORCE_CMD, fy, n*sizeof(float), RAPP_FLOAT);
  rapp_send(outsock, MDCOMM_FORCE_CMD, fz, n*sizeof(float), RAPP_FLOAT);

  free(indicies);
  free(fx);
  return 0;
}



#ifdef MDCOMM
int flag_mdcomm_app_force_cmd = 0;
int mdcomm_app_force_cmd(rapp_active_socket_t *sock)
{
  int tag;
  int n;
  int *indicies;
  float *fx, *fy, *fz;


  flag_mdcomm_app_force_cmd = 1;

  /* get the number of elements */
  rapp_recv(sock, &tag, &n, RAPP_INT);

  /* make room for them */
  indicies = (int *)   malloc(n * sizeof(int));
  fx = (float *) malloc(3 * n * sizeof(float));
  fy = fx + n;
  fz = fy + n;

  /* get the indicies */
  rapp_recv(sock, &tag, indicies, RAPP_INT);
  /* get the x forces */
  rapp_recv(sock, &tag, fx, RAPP_FLOAT);
  /* get the y forces */
  rapp_recv(sock, &tag, fy, RAPP_FLOAT);
  /* get the z forces */
  rapp_recv(sock, &tag, fz, RAPP_FLOAT);


  // call the function in the Node.C to transfer the data to namd
  // node that this function will be called on node 0 only

  mdcomm_transfer_vmdForceData(n,indicies,fx,1);

  /* and print everything out
  fprintf(stderr, "Got new forces\n");
  for (i=0; i<n; i++) {
    fprintf(stderr, "%d \t: index %d\t %f\t %f\t %f\n",
	    i, indicies[i], fx[i], fy[i], fz[i]);
  }
  fflush(stderr);

  */

  // free indicies and fx
  free(indicies);
  free(fx);

  return 0;
}

//////////////////////////////////////////// end of force vectors
#endif

