/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MainFormsObj.C,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.9 $	$Date: 1997/03/22 06:03:29 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The 'controller' for the rest of the forms.  Derived from FormsObj, which
 * is derived from UIObject.
 *
 ***************************************************************************/

#include "MainFormsObj.h"
#include "CmdUtil.h"
#include "Global.h" // for VMDreadHTML

// commands we are interested in
static int numCmds = 1;
static int cmdList[1] = { Command::QUIT };


// class constructor
MainFormsObj::MainFormsObj(UIList *uil, CommandQueue *cq,
	int sh,int bd,int *npos) : FormsObj("main", uil, cq, bd, npos) {
	
  // set values of common menu elements
  form = mainMenu;
  lightButton = main_menu_button;
  offButton = main_menu_off;
  
  // register which commands we are interested in
  for(int i=0; i < numCmds; command_wanted(cmdList[i++]));
  
  // turn on if required
  if(sh)
    On();
}


// routine to check the main form for use
int MainFormsObj::check(FL_OBJECT *obj) {

  if(obj == main_quit_button) {
#if FL_INCLUDE_VERSION > 81
    if(fl_show_question("Really Quit?", 0))
#else
    if(fl_show_question("Really Quit?", "", ""))
#endif
      addcommand(new CmdQuit(FALSE, id()));

  } else if(obj == main_help_button) {
    // open to the VMD quick help page
    VMDreadHTML("quickhelp");
  } else
    return FALSE;

  return TRUE;
}

