/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MolAction.C,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1996/04/28 20:10:06 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A MolAction object is something which performs an 'act' for a Molecule
 * object.  For example, it may change the bond radius or display all
 * alpha carbons.  It is used by the MoleculeList object to perform an
 * action on a list of objects.
 *
 ***************************************************************************/

#include "MolAction.h"
#include "Molecule.h"

#ifdef VMDTCL
#include "UIText.h"
#include "tcl.h"
extern UIText *uiText;
#endif

/////////////////////////////  base class  ///////////////////////////
// destructor
MolAction::~MolAction(void) {
  // does nothing
}

/////////////////////////////  derived classes  /////////////////////

void MolPause::act(Molecule *m) { 
  m->anim_dir(Animation::PAUSE);
#ifdef VMDTCL
  // tell the Tcl variable vmd_frame_action(molid)
  // that a pause was requested.  This is for the kinemage support
  char s[20];
  sprintf(s, "%d", m->id());
  Tcl_SetVar2(uiText -> tclInterp, "vmd_frame_action", s, "pause",
	      TCL_GLOBAL_ONLY);
#endif

}

void MolReverse1::act(Molecule *m) {
  m->anim_dir(Animation::REVERSE1);
#ifdef VMDTCL
  // tell the Tcl variable vmd_frame_action(molid)
  // that a step forward was requested.  This is for the kinemage
  // support
  char s[20];
  sprintf(s, "%d", m->id());
  Tcl_SetVar2(uiText -> tclInterp, "vmd_frame_action", s, "reverse 1",
	      TCL_GLOBAL_ONLY);
#endif
}

void MolReverse::act(Molecule *m) {
  m->anim_dir(Animation::REVERSE);
#ifdef VMDTCL
  char s[20];
  sprintf(s, "%d", m->id());
  Tcl_SetVar2(uiText -> tclInterp, "vmd_frame_action", s, "reverse",
	      TCL_GLOBAL_ONLY);
#endif
}


void MolForward::act(Molecule *m) { 
  m->anim_dir(Animation::FORWARD);
#ifdef VMDTCL
  char s[20];
  sprintf(s, "%d", m->id());
  Tcl_SetVar2(uiText -> tclInterp, "vmd_frame_action", s, "forward",
	      TCL_GLOBAL_ONLY);
#endif
}

void MolForward1::act(Molecule *m) { 
  m->anim_dir(Animation::FORWARD1);
#ifdef VMDTCL
  char s[20];
  sprintf(s, "%d", m->id());
  Tcl_SetVar2(uiText -> tclInterp, "vmd_frame_action", s, "forward 1",
	      TCL_GLOBAL_ONLY);
#endif
}

void MolSetFrame::act(Molecule *m) {
  if(val == SET_FRAME_START)
    m->goto_frame(0);
  else if(val == SET_FRAME_END)
    m->goto_frame(m->num() - 1);
  else
    m->goto_frame(val);

#ifdef VMDTCL
  {
    char s[20];
    sprintf(s, "%d", m->id());
    // and set vmd_frame_action appropriately
    if(val == SET_FRAME_START)
      Tcl_SetVar2(uiText -> tclInterp, "vmd_frame_action", s, "goto start",
		  TCL_GLOBAL_ONLY);
    else if(val == SET_FRAME_END)
      Tcl_SetVar2(uiText -> tclInterp, "vmd_frame_action", s, "goto end",
		  TCL_GLOBAL_ONLY);
    else
      {
	char f[20];
	sprintf(f, "goto %d", val);
	Tcl_SetVar2(uiText -> tclInterp, "vmd_frame_action", s, f,
		    TCL_GLOBAL_ONLY);
      }
  }
#endif  
}

void MolSetSkip::act(Molecule *m) { m->skip(val); }

void MolAnimStyle::act(Molecule *m) {
  m->anim_style(newstyle);
#ifdef VMDTCL
  char s[20];
  sprintf(s, "%d", m->id());
  char *q = ( newstyle == Animation::ONCE ? "style once" :
	      newstyle == Animation::LOOP ? "style loop" :
	                                    "style rock" );
  Tcl_SetVar2(uiText -> tclInterp, "vmd_frame_action", s, q,
	      TCL_GLOBAL_ONLY);
#endif

}

void MolSetSpeed::act(Molecule *m) { m->speed(speed); }

