/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: Molecule.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.7 $	$Date: 1996/03/24 14:01:23 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Main Molecule objects, which contains all the capabilities necessary to
 * store, draw, and manipulate a molecule.  This adds to the functions of
 * DrawMolecule and BaseMolecule by adding routines to read and write various
 * coordinate files.
 *
 * Note: Other capabilities, such as writing structure files, mutations, etc.
 * should go into this level.
 *
 ***************************************************************************/
#ifndef MOLECULE_H
#define MOLECULE_H

#include "DrawMolecule.h"
#include "ResizeArray.h"
#include "CoorFileData.h"
#include "utilities.h"


class Molecule : public DrawMolecule {

public:
  // where did this molecule come from?
  char *source;
  int filetype;  // MoleculeFile::PDB, PSF, ...

  // for PSF files, I need to know the name of the PDB/DCD file, if it
  // was given
  char *source2;
  int filetype2;

private:
  // Coordinate files we are supposed to read/write.  Only one will be accessed
  // at a time, though, so we must maintain a list.
  ResizeArray<CoorFileData *> coorIOFiles;
  
public:
  // constructor ... nothing much to do, just save the source, and pass on
  // the other data.
  Molecule(char *, Scene *);
  Molecule(char *, Displayable *);
  
  // destructor ... just clear out unread files
  virtual ~Molecule(void);
  
  // set the info about the file type
  void set_primary_type(int typ);  // name is in constructor
  // and the 2nd file info (if it exists for this molecule)
  void set_secondary_info(char *name, int typ);

  // no need for create routine here ... there is nothing for this
  // level to create.

  //
  // requests to process files
  //

  // ask to read in a coordinate file of the specified type
  // arguments: filename, type, beginning frame, ending frame, frame skip
  // (if any of the last three are < 0, default values for that arg used)
  // return succes.
  int read_coor_file(char *, int, int=(-1), int=(-1), int=(-1));

  // ask to write out a coordinate file of the specified type
  // arguments: filename, type, beginning frame, ending frame, frame skip
  // (if any of the last three are < 0, default values for that arg used)
  // return succes.
  int write_coor_file(char *, int, int=(-1), int=(-1), int=(-1));

  //
  // public virtual routines for Displayable
  //
  
  // prepare for drawing ... do any updates needed right before draw.
  // This possibly reads a new timestep, if requested.
  virtual void prepare(DisplayDevice *);

};

#endif

