/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: MoleculeFilePARM.C,v $
 *      $Author: ulrich $        $Locker:  $                $State: Exp $
 *      $Revision: 1.1 $      $Date: 1997/03/20 04:12:45 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************/



#include "MoleculeFilePARM.h"
#include "ReadPARM.h"

MoleculeFilePARM::MoleculeFilePARM(char *filename, Scene *sc)
: MoleculeFile(filename, sc) {}

MoleculeFilePARM::MoleculeFilePARM(char *filename, Displayable *disp)
: MoleculeFile(filename, disp) {}

MoleculeFilePARM::~MoleculeFilePARM(void) {}

int MoleculeFilePARM::create(void){
   // read structure from parm file
   if(!(createFromPARM(strFile))) 
      return FALSE;
   return(MoleculeFile::create());
}

// read in a molecule structure from the specified parm file.
// Return TRUE if molecule was successfully read, FALSE if there is an error
int MoleculeFilePARM::createFromPARM(char *parmfile) {

  ReadPARM rp;
  FILE *parm;
  char chain[2];
  int natoms, nbonds, i, *from, *to, rid;
  int box_info;
  char names[8], rnames[8], segnames[8], atypes[8], ridstr[8];
  float charges, masses, newpos[ATOMCOORDS];
  float newdata[ATOMEXTRA_DYNAMIC + ATOMEXTRA_STATIC];

  // first read the parm for structure info
  if(!(parm = rp.open_parm_file(parmfile))) {
    msgErr << "Cannot open structure file '" << parmfile << "'." << sendmsg;
    return FALSE;
  }

  MSGDEBUG(2,"MoleculeFile: Creating structure from parm" << sendmsg);
  rp.readparm(parm);
  natoms = rp.get_parm_natoms();
  nbonds = rp.get_parm_nbonds();
  box_info = rp.get_parm_boxInfo();
//  printf ("NATOMS = %d\n", natoms);
//  printf ("NBONDS = %d\n", nbonds);
  MSGDEBUG(2,"   Reading " << nbonds << " bonds ..." << sendmsg);

  // initialize data arrays that are used to create new atoms
  for(i=0; i < ATOMCOORDS; newpos[i++] = 0.0);
  newdata[ATOMBETA] = default_beta();
  newdata[ATOMOCCUP] = default_occup();
  newpos[0] = newpos[1] = newpos[2] = 0.0;
  from = new int[nbonds];
  to = new int[nbonds];
  init_atoms(natoms);
  init_boxInfo(box_info);
  chain[1] = '\0';

  for (i=0; i < natoms;i++) {
    rp.get_parm_atom(i, names, atypes, rnames, segnames, &rid, &charges,
      &masses);
    if (rid < 10000000)
      sprintf(ridstr,"%d",rid);
    else
      strcpy(ridstr,"*******");
    newdata[ATOMCHARGE] = charges;
    newdata[ATOMMASS] = masses;
    newdata[ATOMRAD] = default_radius(names);
    // remember, no chains in PSF file:
    chain[0] = ' ';
    add_atom(names, atypes, rnames, ridstr, chain, segnames, newpos, newdata);
  }


  // add bonds to current structure
  for(i=0; i < nbonds; i++) {
    rp.get_parm_bond (i, from, to);
    if ( ((from[i]-1) < natoms) || ((to[i] - 1) < natoms) )
       add_bond(from[i] - 1, to[i] - 1);
  }
    
  delete [] to;
  delete [] from;

  rp.close_parm_file(parm);

  MSGDEBUG(2,"Finished reading parm" << sendmsg);

  return TRUE;
}

