/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MoleculeGraphics.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1996/02/21 16:46:03 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * This simply stores and retrieves graphics objects (nominally for use
 *  by the text interface).
 * 
 ***************************************************************************/



// This file name is actually a misnomer since it is derived from
// MoleculeFile .
#include "MoleculeFile.h"

class MoleculeGraphics : public MoleculeFile
{
public:
  enum Shapes {NONE, POINT, TRIANGLE, TRINORM, LINE, CYLINDER, CONE,
	SPHERE, TEXT, COLOR, MATERIALS};
public:
  class ShapeClass {
  public:
    int id;
    Shapes shape;
    float *data;
    ShapeClass(void) { data = NULL; shape = NONE; id = -1;}
    // Can't do deletion here because of how ResizeArray resizes
    //    ~ShapeClass(void) { if (data) delete [] data; }
    void assign(Shapes new_shape, float *new_data, int new_id) {
      shape = new_shape;
      if (data) delete [] data;
      data = new_data;
      id = new_id;
    }
    void assign(Shapes new_shape, float *new_data) {
      shape = new_shape;
      if (data) delete [] data;
      data = new_data;
    }
  };
protected:
  ResizeArray<ShapeClass> shapes;

  int max_id, next_id;
  int next_index;   // this is usually the end unless replace was called
  int delete_count; // total number of deleted elements
  int needRegenerate;
  int added(void); // actions after adding a new shape
  float cov_scale, cov_pos[3];
  void find_sizes(void);
public:
  MoleculeGraphics(char *filename, Scene *sc) : 
    MoleculeFile(filename, sc){
      delete [] source;
      source = new char[9];
      sprintf(source, "Graphics", filename);
      max_id = 0;
      next_id = 0;
      next_index = 0;
      needRegenerate = 1;
      delete_count = 0;
  }
  MoleculeGraphics(char *filename, Displayable *disp) : 
    MoleculeFile(filename, disp){
      delete [] source;
      source = new char[9];
      sprintf(source, "Graphics", filename);
      max_id = 0;
      next_id = 0;
      next_index = 0;
      needRegenerate = 1;
      delete_count = 0;
  }
  virtual ~MoleculeGraphics(void){
    // this is where I delete the data elements
    delete_data();
  }
protected:
  // delete the data elements
  void delete_data(void);
  void delete_data(int start, int stop);


public:
  virtual void prepare(DisplayDevice *) {
    if (!needRegenerate) return;
    create_cmdlist();
  }
  // of course I can create a blank graphics type
  virtual int create(void){return MoleculeFile::create();}

  // center of volume, and scaling factor
  virtual void cov(float &x, float &y, float &z) {
    find_sizes(); x = cov_pos[0]; y = cov_pos[1]; z = cov_pos[2];
  }
  virtual float scale_factor(void) {
    find_sizes(); return cov_scale;
  }

  // regenerate the draw list
  virtual void create_cmdlist(void);

  // manipulate the data values
  int add_point(float *x);
  int add_triangle(float *x1, float *x2, float *x3);
  int add_trinorm(float *x1, float *x2, float *x3,
		  float *nx1, float *nx2, float *nx3);
  int add_line(float *x, float *y, int line_style, int width);
  int add_cylinder(float *x, float *y, 
		   float radius, int res, int filled);
  int add_cone(float *x, float *y, 
	       float radius, int res);
  int add_sphere(float *x, float r, int res);
  int add_text(float *x, char *text);

  int use_materials(int yes_no);
  int use_color(float r, float g, float b);
  int use_color(int index);
  
  void delete_id(int id); // delete an entry
  void delete_all(void); // delete everything
  int replace_id(int id); // same as delete, but next addition goes here
  int index_id(int id);  // returns -1 if doesn't exist, else the index
  int num_elements(void){return shapes.num();}
  int element_id(int index) { return shapes[index].shape != NONE ? shapes[index].id : -1; }
  const ShapeClass& element(int n);

  // return data to make shape; static string space is always used
  // return NULL if doesn't exist or is NONE
  const char *info_id(int id);

};
