/***************************************************************************
 *cr
 *cr		(C) Copyright 1995 The Board of Trustees of the
 *cr			    University of Illinois
 *cr			     All Rights Reserved
 *cr
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MoleculeSigma.h,v $
 *	$Author: leech $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 96/11/22 03:04:57 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * A MoleculeSigma is inherited from MoleculeFile, and supplies additional
 * routines to link the Molecule with the SIgMA MD code.
 *
 ***************************************************************************/
#ifndef MOLECULESIGMA_H
#define MOLECULESIGMA_H

#include "MoleculeFilePDB.h"
#include "MoleculeFilePSF.h"

// These are additional "events" recognized by MoleculeSigma::send_event,
//  but not passed on to SigmaX. They are guaranteed not to collide with
//  MDMessageTypes defined in Graphics.h
#include <mdio/Graphics.h>
#include <mdio/global.h>

enum SMDMessageTypes {
    SMD_CMD_CONNECT = MD_NUM_EVENTS + 1,
    SMD_CMD_DISCONNECT,
    SMD_CMD_FORCE_CONSTANT,
    SMD_CMD_LIST_TUGS
};

class DrawTugs;

// Methods to communicate with Sigma using mdio library and to
//  implement the GUI for specifying restraints. This object
//  is used by Molecule-derived classes which wish to implement
//  SMD capabilities.
class MoleculeSigma {
protected:
    // Connect to and disconnection from Sigma simulation
    void connect();
    void disconnect();
    int  connected();

    // Read molecule coordinates
    void read_coords(char *);

    // File descriptor of communications socket
    int sock;

    // Pick mode generated for tugging
    int tugPickMode;

    // ID of the tug currently being manipulated
    int cur_tug_id;

    // Mode in which simulation is updating:
    //	Smd{Idle,Mouse,Synchronous,Continuous}
    SmdComputeMode update_mode;

    // Force constant for defining tugs
    float tug_force;

    // Whether coordinates have been received since the last request
    int received_update;

    // The Molecule containing this object, and corresponding to the Sigma
    //	simulation.
    Molecule *mol;

    // The class containing information on restraints - definitions,
    //	GUI semantics, and how to draw them.
    DrawTugs *drawTugs;

public:
    // class constructor/destructor
    MoleculeSigma(Molecule *);
    virtual ~MoleculeSigma(void);

    // read incoming messages
    void read_input();

    // send outgoing messages
    void send_event(int);
    void send_event(int, int);			// int param
    void send_event(int, float);		// float param
    void send_event(int, float, float, float);	// Point3 param
    void send_event(int, TugInfo *);		// TugInfo param

    // return if we are interested in the given pick mode or not
    virtual int want_pick_mode(int);
    PickMode *create_pick_mode(int);

    // Returns representation index corresponding to the Pickable
    int find_representation(Pickable *);
    int get_atom_position(int, float *);

    // called when a pick is begun / moves / ends
    //	  args = display to use, obj picked, button, mode, tag, dim, pos
    // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
    // For 3D version: x,y,z are transformed position of pointer
    virtual void pick_start(DisplayDevice *, Pickable *,
				  int, int, int, int, float *);
    virtual void pick_move(DisplayDevice *, Pickable *,
				  int, int, int, int, float *);
    virtual void pick_end(DisplayDevice *, Pickable *,
				  int, int, int, int, float *);
};

class MoleculeSigmaFilePDB : public MoleculeFilePDB {
private:
    MoleculeSigma *sigma;

public:
    //	class constructor/destructor
    MoleculeSigmaFilePDB(char *, Scene *);
    MoleculeSigmaFilePDB(char *, Displayable *);
    virtual ~MoleculeSigmaFilePDB(void);

    // prepare for drawing ... do any updates needed right before draw.
    // This possibly reads a new timestep, if requested.
    virtual void prepare(DisplayDevice *);

    // Pickable overrides, for adding restraints

    // Returns if we're interested in the given pick mode or not
    virtual int want_pick_mode(int);
    PickMode *create_pick_mode(int);

    // called when a pick is begun / moves / ends
    virtual void pick_start(DisplayDevice *, Pickable *,
				  int, int, int, int, float *);
    virtual void pick_move(DisplayDevice *, Pickable *,
				  int, int, int, int, float *);
    virtual void pick_end(DisplayDevice *, Pickable *,
				  int, int, int, int, float *);
};

// Not implemented yet
class MoleculeSigmaFilePSF : public MoleculeFilePSF {
private:
    MoleculeSigma *sigma;

public:
    //	class constructor/destructor
    MoleculeSigmaFilePSF(char *, Scene *);
    MoleculeSigmaFilePSF(char *, Displayable *);
    virtual ~MoleculeSigmaFilePSF(void);

    // prepare for drawing ... do any updates needed right before draw.
    // This possibly reads a new timestep, if requested.
    virtual void prepare(DisplayDevice *);

    // Pickable overrides, for adding restraints

    // Returns if we're interested in the given pick mode or not
    virtual int want_pick_mode(int);
    PickMode *create_pick_mode(int);

    // called when a pick is begun / moves / ends
    virtual void pick_start(DisplayDevice *, Pickable *,
				  int, int, int, int, float *);
    virtual void pick_move(DisplayDevice *, Pickable *,
				  int, int, int, int, float *);
    virtual void pick_end(DisplayDevice *, Pickable *,
				  int, int, int, int, float *);
};

#endif
