/***************************************************************************
 *cr
 *cr            (C) Copyright 1995 The Board of Trustees of the
 *cr                        University of Illinois
 *cr                         All Rights Reserved
 *cr
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: MouseEvent.h,v $
 *      $Author: leech $                $Locker:  $                $State: Exp $
 *      $Revision: 1.1 $              $Date: 1995/07/26 02:58:25 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * MouseEvent describes an event (button press/release or motion).
 * A three-button mouse is assumed.
 *
 ***************************************************************************/
#ifndef MOUSEEVENT_OBJ_H
#define MOUSEEVENT_OBJ_H

class MouseEvent {
public:
  enum EventType { BUTTON_DOWN = 0, MOTION, BUTTON_UP };
  enum MouseButton {
    B_NONE = -1, B_LEFT = 0, B_MIDDLE, B_RIGHT, B_NUM_BUTTONS };

  MouseEvent(EventType ev, int b, int x, int y) :
    eventType(ev), buttonSelected(b), mouseX(x), mouseY(y)
  { }

  EventType type() const { return eventType; }
  int       button() const { return buttonSelected; }
  int       x() const { return mouseX; }
  int       y() const { return mouseY; }

protected:
  EventType eventType;
  int       buttonSelected; // The button pressed or released
  int       mouseX, mouseY; // Window position of the event
};

#endif
