/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: MoveTool.C,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1995/12/18 22:30:11 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *   Code for the Tool which moves an atom
 *
 ***************************************************************************/

#include "MoveTool.h"
#include "ToolControl.h"
#include "Buttons.h"
#include "CommandQueue.h"
#include "Global.h"
#include "CmdPick.h"
#include "Mouse.h"
#include "MouseEvent.h"
#include "CommandQueue.h"
#include "Molecule.h"
#include "MoleculeList.h"

void MoveTool::redraw_list(ToolInfo *info) {
  
  reset_disp_list();  // clear out everything
  
  // the default picture is a simple cylinder with a cone end
  switch (info->detail ) {
    case 1:  // draw a simple line with a cheap end
       {float tip[3]  = {1,0,0}; 
       float base[3] = {0,0,0};
       drawcolor.putdata(info -> toolid, this);  // color each tool differently
       drawline.putdata(base, tip, this);  // line
        base[0] = 0.9;
        base[1] = 0.1;
       drawcolor.putdata(info -> toolid + 1, this);
        drawline.putdata(base, tip, this);  // and tip
        base[1] = -base[1];
        drawline.putdata(base, tip, this);
        base[2] = base[1];
        base[1] = 0.0;
        drawline.putdata(base, tip, this);
        base[1] = -base[1];
        drawline.putdata(base, tip, this);}
      break;
    case 2:  // draw a cylinder with different sized radii
       draw_cylindrical_pointer(info, 3);
      break;
    case 3:
       draw_cylindrical_pointer(info, 4);
      break;
    case 4:
       draw_cylindrical_pointer(info, 6);
      break;
    case 5:
       draw_cylindrical_pointer(info, 10);
      break;
    case 6:
       draw_cylindrical_pointer(info, 16);
      break;
    case 7:  // include material characteristics
       drawmaterials.putdata(TRUE, this);
       draw_cylindrical_pointer(info, 12);
       drawmaterials.putdata(FALSE, this);
      break;
    case 8:
       drawmaterials.putdata(TRUE, this);
       draw_cylindrical_pointer(info, 12);
       drawmaterials.putdata(FALSE, this);
      break;
    case 9:
       drawmaterials.putdata(TRUE, this);
       draw_cylindrical_pointer(info, 16);
       drawmaterials.putdata(FALSE, this);
      break;
    case 10: 
       drawmaterials.putdata(TRUE, this);
       draw_cylindrical_pointer(info, 24);
       drawmaterials.putdata(FALSE, this);
      break;
    default:  // same as 5
       draw_cylindrical_pointer(info, 10);
      break;
  }
}

//
//  Cone with a sphere at the end
//
//  \_____           
//        \__________
//                  _\|_
//         __________/|
//   _____/
//  /

void MoveTool::draw_cylindrical_pointer(ToolInfo *info, int numsides)
{
  if (numsides < 3) numsides = 3;
  if (numsides > 30) numsides = 30;
  float base[3] = {0.0,0.0,0.0};
  float tip[3] = {1.0, 0.0, 0.0};
  drawcolor.putdata(info -> toolid, this);  // color each tool differently
  drawcone.putdata(base, tip, 0.7, numsides, this);
  sphereres.putdata(numsides / 2 + 3, this);
  drawcolor.putdata(REGSILVER, this);
  drawsphere.putdata(tip, 0.02, this);
}

// Am I grabbing anything?  If so, move it
void MoveTool::tool_event(ToolControl *, ToolInfo *toolinfo)
{
  if (!grabbed) return;
  
  // compute the difference between the picked atom and the tip
  // that becomes the force to use
  Molecule *mol = moleculeList->molecule(moleculeList->
					 mol_index_from_id(move_mol));
  
  if (!mol || mol->frame() < 0) {  // for instance, it is deleted under me
    msgErr << "Either no molecule or no time step for index " 
	   << move_mol << sendmsg;
    grabbed = 0;
    return;
  }
  // convert the tip position to the molecule's space
  Matrix4 tminv(mol -> tm);
  tminv.inverse();
  float tip[3];
  tminv.multpoint3d(toolinfo -> tip, tip);

  // get the current atom position
  Timestep *ts = mol->current();
  float *pos = ts -> pos + 3 * move_atom;
  
  // move the atom there
  copy(pos, tip);

  // and force a redraw (since a location moved)
  mol -> force_recalc();
}


// check which button was pushed, and change the appropriate state 
void MoveTool::button_event(ToolControl *, ToolInfo *toolinfo)
{
  Buttons *checkbuttons;
  if (!(checkbuttons=toolinfo -> buttons))
    return;
  
  // if button 0 was pressed, change the current grab state
  if (checkbuttons -> change(0) == 1) {
    grabbed = !grabbed;
  }

  if (grabbed) {
    move_mol = -1; // reset the variables
    move_atom = -1;

    //// Get the atom and molecule numbers
    // From the pick list, get the pickable
    int tag;
    Pickable *p;
    if (display) {
      p = scene -> pick_check(display, 3, toolinfo -> tip, tag);
      if (p) {
	Molecule *m = moleculeList -> check_pickable(p);
	if (m) {
	  move_mol = m->id();
	  move_atom = tag;
	  msgInfo << "Moving molecule " << move_mol << " atom " 
		  << move_atom << sendmsg;
	}
      }
    }
    if (move_mol == -1) grabbed = 0;
  }
}
