/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: OpenGLDisplayDevice.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 96/03/25 17:19:41 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Subclass of OpenGLRenderer, this object has routines used by all the
 * different display devices that are OpenGL-specific.  Will render drawing
 * commands into a single X window.
 *
 ***************************************************************************/
#ifndef OPENGLDISPLAYDEVICE_H
#define OPENGLDISPLAYDEVICE_H

#include "OpenGLRenderer.h"
#include "PopupMenu.h"
#include <GL/glx.h>

#define OPENGL_STEREO_OFF            0
#define OPENGL_STEREO_CRYSTAL        1
#define OPENGL_STEREO_CROSSED        2
#define OPENGL_STEREO_SIDE           3
#define OPENGL_STEREO_LEFT           4
#define OPENGL_STEREO_RIGHT          5
#define OPENGL_STEREO_MODES		6


class OpenGLDisplayDevice : public OpenGLRenderer {

private:
  // X server and screen
  Display *dpy;
  int dpyScreen;

  // id number of the graphics display X window, and the root window
  Window windowID;
  Window rootWindowID;

  // graphics context
  GLXContext cx;

  // cursor as it is displayed in the graphics window
  Cursor cursor[5];

  // font to use for our display
  XFontStruct *fontStruct;
  Font fontID;

  // can we display stereo-in-a-window?
  int stereoInWindow;

  // do we have a currently-defined pop-up menu?
  PopupMenu *mainMenu;

protected:
  // create a new window and set it's characteristics
  Window open_window(char *, int *, int *, int, char **);

  //
  // stereo routines and data
  //

  // functions used to set perspective for normal or stereo view
  void set_persp(DisplayEye = NOSTEREO);

public:
  // constructor/destructor
  // arguments: argc/argv from main, 
  // and the size and location for the window, if known
  OpenGLDisplayDevice(int, char **, int *size = NULL, int *loc = NULL);
  virtual ~OpenGLDisplayDevice(void);

  //
  // get the current state of the device's pointer (i.e. cursor if it has one)
  //

  virtual int x(void);		// abs pos of cursor from lower-left corner
  virtual int y(void);		// same, for y direction
  virtual int button_down(int);	// whether a button is currently pressed
  virtual int shift_state(void);// return the shift state (ORed of the
				// enum in DisplayDevice)

  // allow the user to define a special shape for the cursor ... the data
  // is assumed to consist of a single-dim array of 32 unsigned shorts; the
  // first 16 define a 16x16-bit (row-major) pattern, the last 16 are a
  // "second layer" which may be drawn in a different color
  // args: which shape (>0, with 0 the "default" case which cannot be changed)
  // the bitmap data, and the "hot spot" from the lower-left corner
  virtual void change_cursor_shape(int, unsigned short *, int, int);

  // set the Nth cursor shape as the current one.  If no arg given, the
  // default shape (n=0) is used.
  virtual void set_cursor(int = 0);

  //
  // virtual routines to create and activate a popup (possibly pull-down) menu 
  //

  // given a PopupMenu definition, create it in the window (but do not
  // activate it yet).  Return success.
  virtual int menu_create(PopupMenu *);

  // activate a previously-created menu.  If the windowing system has no
  // current menu, or cannot do this operation, returns (-1); otherwise,
  // returns the return code for the select (-1 if none selected).
  virtual int menu_activate(void);

  // delete the given menu from the display.
  // If no argument is given, deletes the current menu (if any).
  // Returns success.
  virtual int menu_delete(PopupMenu * = NULL);

  //
  // event handling routines
  //

  // queue the standard events (need only be called once ... but this is
  // not done automatically by the window because it may not be necessary or
  // even wanted)
  virtual void queue_events(void);

  // test if there is an event ready
  virtual int test_events(void);

  // read the next event ... returns an event type (one of the above ones),
  // and a value.  Returns success, and sets arguments.
  virtual int read_event(long &, long &);

  //
  // routines to deal with stereo display
  //
  
  // change to a different stereo mode (0 means 'off')
  virtual void set_stereo_mode(int = 0);

  //
  // virtual routines for preparing to draw, drawing, and finishing drawing
  //
  
  virtual int prepare2D(int do_clear = TRUE);	// ready to draw 2D
  virtual int prepare3D(int do_clear = TRUE);	// ready to draw 3D
  virtual void clear(void);			// erase the device
  virtual void left(void);			// ready to draw left eye
  virtual void right(void);			// ready to draw right eye
  virtual void normal(void);			// ready to draw non-stereo
  virtual void update(int do_update = TRUE);	// finish up after drawing
  virtual void reshape(void);			// refresh device after change

};

#endif

