/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: OpenGLRenderer.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1997/03/24 22:12:50 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Subclass of DisplayDevice, this object has routines used by all the
 * different display devices that use OpenGL for rendering.
 * Will render drawing commands into a window.
 * This is not the complete definition,
 * however, of a DisplayDevice; something must provide routines to open
 * windows, reshape, clear, set perspective, etc.  This object contains the
 * code to render a display command list.
 *
 ***************************************************************************/
#ifndef OPENGLRENDERER_H
#define OPENGLRENDERER_H

#include "DisplayDevice.h"
#include <GL/gl.h>
#include <GL/glu.h>

// forward declaration of classes here
class OpenGLRenderer;


// the class definition
class OpenGLRenderer : public DisplayDevice {

private:
  // pointer to data block (should be changed to allow for multiple blocks)
  float *dataBlock;

  // do we need to turn antialiasing and depth-cueing on when materials
  // are turned off?
  int need_aaon, need_cueon;

  // quadric objects for drawing spheres, cylinders, and disks
  GLUquadricObj *pointsQuadric;
  GLUquadricObj *objQuadric;
  GLUquadricObj *sphereQuadric;

protected:
  // font info to use for our display ... MUST BE SET BY DERIVED CLASS
  int haveFontData;
  GLuint fontListBase;

  // total size of the screen, in pixels ... MUST BE SET BY DERIVED CLASS
  int screenX, screenY;

  // routines to perform various OGL-specific graphics operations
  void set_line_width(int);
  void set_line_style(int);
  void set_sphere_res(int);
  void set_sphere_mode(int);
  void triangle(float *x1, float *x2, float *x3,
		float *n1, float *n2, float *n3);  // triangle with normals
  void square(float *norm, float *, float *, float *, float *); 
  void cylinder(float *, float *, int, float, float);  // slow cylinder version
#ifndef USE_SLOW_CYLINDERS
  void cylinder(int num, float *edges, int filled);  // fast, if precomputed
#endif
  //
  // protected virtual routines
  //
  
  // virtual routines to deal with light sources at device level
  // all return success of operation
  virtual int do_define_light(int n, float *color, float *position);
  virtual int do_activate_light(int n, int turnon);

  // virtual routines to deal with materials at device level
  // all return success of operation
  virtual int do_define_material(int n, float *data);
  virtual int do_activate_material(int n, int turnon);

public:
  // constructor/destructor
  OpenGLRenderer(char *);
  virtual ~OpenGLRenderer(void);

  //
  // virtual routines to affect the devices transformation matrix
  //
  
  virtual void push(void);		// push device's curr state on stack
  virtual void pop(void);		// pop device's curr state from stack
  virtual void loadmatrix(Matrix4 &);	// replace trans matrix w. given one
  virtual void multmatrix(Matrix4 &);	// multiply trans matrix w. given one

  //
  // virtual routines to find characteristics of display itself
  //

  // return absolute 2D screen coordinates, given 2D or 3D world coordinates.
  virtual void abs_screen_loc_3D(float *, long *);
  virtual void abs_screen_loc_2D(float *, long *);

  // size of physical display object
  virtual void screen_size_mm(long &, long &);
  virtual void screen_size_pixel(long &, long &);

  // Given a 3D point (pos A),
  // and a 2D rel screen pos point (for pos B), computes the 3D point
  // which goes with the second 2D point at pos B.  Result returned in B3D.
  virtual void find_3D_from_2D(float *A3D, float *B2D, float *B3D);

  //
  // virtual functions to turn on/off depth cuing and antialiasing
  //
  
  virtual void aa_on(void);
  virtual void aa_off(void);
  virtual void cueing_on(void);
  virtual void cueing_off(void);

  //
  // virtual routines for preparing to draw, drawing, and finishing drawing
  //
  
  virtual void render(void *);		// process list of draw cmds

};

#endif

