/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: POV3DisplayDevice.h,v $
 *	$Author: ulrich $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1997/03/21 17:17:27 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 *  Version 3 of the Persistence Of Vision raytracer
 *
 *
 ***************************************************************************/

#ifndef POV3DISPLAYDEVICE
#define POV3DISPLAYDEVICE

#include <stdio.h>
#include "FileRenderer.h"


class POV3DisplayDevice : public FileRenderer {

private:

  
protected:

  //
  // assorted graphics functions
  //
  
  void point(float *xyz);
  void sphere(float *xyzr);
  void line(float *xyz1, float *xyz2);
  void cylinder(float *, float *, float rad, int filled);
  void cone(float * a, float * b, float rad); 
  void triangle(float *, float *, float *, float *, float *, float *);
  void square(float *, float *, float *, float *, float *);
  void comment (char *);
   
public: 
  // constructor/destructor

  POV3DisplayDevice(void);
  virtual ~POV3DisplayDevice(void);
  
/*  virtual int prepare3D(int = TRUE);*/
  void write_header(void); 
  void write_trailer(void);

  /*virtual void update(int = TRUE);*/
  
}; 

#endif


