/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
* RCS INFORMATION:
*
*      $RCSfile: POVDisplayDevice.C,v $
*      $Author: ulrich $        $Locker:  $               $State: Exp $
*      $Revision: 1.14 $        $Date: 1997/03/21 17:48:33 $
*
***************************************************************************
* DESCRIPTION:
*
* FileRenderer type for the Persistence of Vision raytracer
* (With the advent of v3, this will no longer be supported,
*  see POV3DisplayDevice instead)
*
***************************************************************************/

#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <math.h>
#include "POVDisplayDevice.h"
#include "Stack.h"
#include "Matrix4.h"
#include "DispCmds.h"
#include "Inform.h"
#include "utilities.h"

#define DEFAULT_RADIUS 0.002
#define DASH_LENGTH 0.02

///////////////////////// constructor and destructor

// constructor ... initialize some variables

POVDisplayDevice::POVDisplayDevice() : FileRenderer("POV","plot.pov",
                                    "povray +H250 +W200 -I%s -O%s.tga +P +X +A +FT"){
	
    MSGDEBUG(1,"Creating POVDisplayDevice ..." << sendmsg);
}
        
// destructor
POVDisplayDevice::~POVDisplayDevice(void) { }

///////////////////////// protected nonvirtual routines

// draw a point
void POVDisplayDevice::point(float spdata[]) {
    float vec[3];
    // transform the world coordinates
    (transMat.top()).multpoint3d(spdata, vec);
   
    // draw the sphere
  
    fprintf(outfile, "sphere {\n");  // sphere
    // center of sphere
    fprintf(outfile, "  <%5f, %5f, %5f>, \n ", vec[0], vec[1], -vec[2]);
    // the radius of the sphere
    fprintf(outfile, "  %5f \n", float(lineWidth)*DEFAULT_RADIUS ); 
    fprintf(outfile, "  pigment { rgb<%3.2f, %3.2f, %3.2f> } \n", 
	matData[colorIndex][DIFFUSE_INDEX+0],
	matData[colorIndex][DIFFUSE_INDEX+1],
	matData[colorIndex][DIFFUSE_INDEX+2]);
        /*currentColor[0], currentColor[1], currentColor[2]);*/
    fprintf(outfile, "  finish{ phong %3.2f }\n", matData[colorIndex][SHININESS_INDEX]/64.0);
    fprintf(outfile, "}\n");
}

// draw a sphere
void POVDisplayDevice::sphere(float spdata[]) {
    float vec[3];
    float radius;
    
    // transform the world coordinates
    (transMat.top()).multpoint3d(spdata, vec);
    radius = scale_radius(spdata[3]);
   
    // draw the sphere
  
    fprintf(outfile, "sphere {\n");  // sphere
    // center of sphere
    fprintf(outfile, "  <%5f, %5f, %5f>, \n ", vec[0], vec[1], -vec[2]);
    // the radius of the sphere
    fprintf(outfile, "  %5f \n", radius ); 
    fprintf(outfile, "  pigment { rgb<%3.2f, %3.2f, %3.2f> } \n", 
	matData[colorIndex][DIFFUSE_INDEX+0],
	matData[colorIndex][DIFFUSE_INDEX+1],
	matData[colorIndex][DIFFUSE_INDEX+2]);
    fprintf(outfile, "  finish{ phong %3.2f }\n", matData[colorIndex][SHININESS_INDEX]/128.0);
    fprintf(outfile, "}\n");
}

// draw a line (cylinder) from a to b
void POVDisplayDevice::line(float *a, float*b) {
    int i, j, test;
    float dirvec[3], unitdirvec[3];
    float from[3], to[3], tmp1[3], tmp2[3];
    float len;
    
    if(lineStyle == ::SOLIDLINE ) {
  
        // transform the world coordinates
        (transMat.top()).multpoint3d(a, from);
        (transMat.top()).multpoint3d(b, to);
    
        // draw the cylinder
        fprintf(outfile, "cylinder {\n"); // flat-ended cylinder
        // first point
        fprintf(outfile, "  <%5f, %5f, %5f>,\n", from[0], from[1], -from[2]); 
        // second point
        fprintf(outfile, "  <%5f, %5f, %5f>,\n ", to[0], to[1], -to[2]);
        // radius 2
        fprintf(outfile, "  %5f \n", float(lineWidth)*DEFAULT_RADIUS);
        fprintf(outfile, "  pigment { rgb<%3.2f, %3.2f, %3.2f> } \n", 
	matData[colorIndex][DIFFUSE_INDEX+0],
	matData[colorIndex][DIFFUSE_INDEX+1],
	matData[colorIndex][DIFFUSE_INDEX+2]);
        fprintf(outfile, "  finish{ phong %3.2f }\n", matData[colorIndex][SHININESS_INDEX]/128.0);
        fprintf(outfile, "}\n");
        
    } else if (lineStyle == ::DASHEDLINE ) {
        
         // transform the world coordinates
        (transMat.top()).multpoint3d(a, tmp1);
        (transMat.top()).multpoint3d(b, tmp2);

        // how to create a dashed line
        for(i=0;i<3;i++) {
            dirvec[i] = tmp2[i] - tmp1[i];  // vector from a to b
        }
        len = sqrtf( dirvec[0]*dirvec[0] + dirvec[1]*dirvec[1] + dirvec[2]*dirvec[2] );
        for(i=0;i<3;i++) {
            unitdirvec[i] = dirvec[i] / sqrtf(len);  // unit vector pointing from a to b
        }
           
        test = 1;
        i = 0;

        while( test == 1 ) {
            for(j=0;j<3;j++) {
                from[j] = tmp1[j] + (2*i)*DASH_LENGTH*unitdirvec[j];
                to[j] = tmp1[j] + (2*i + 1)*DASH_LENGTH*unitdirvec[j];
            }
            if( fabsf(tmp1[0] - to[0]) >= fabsf(dirvec[0]) ) {
                for(j=0;j<3;j++) {
                    to[j] = tmp2[j];
                }
                test = 0;
            }
    
            // draw the cylinder
            fprintf(outfile, "cylinder {\n"); // flat-ended cylinder
            // first point
            fprintf(outfile, "  <%5f, %5f, %5f>,\n", from[0], from[1], -from[2]); 
            // second point
            fprintf(outfile, "  <%5f, %5f, %5f>,\n", to[0], to[1], -to[2]);
            // radius 2
            fprintf(outfile, "  %5f \n", float(lineWidth)*DEFAULT_RADIUS);
            fprintf(outfile, "  pigment { rgb<%3.2f, %3.2f, %3.2f> } \n", 
	            matData[colorIndex][DIFFUSE_INDEX+0],
	            matData[colorIndex][DIFFUSE_INDEX+1],
	            matData[colorIndex][DIFFUSE_INDEX+2]);
            fprintf(outfile, "  finish{ phong %3.2f }\n", matData[colorIndex][SHININESS_INDEX]/128.0);
            fprintf(outfile, "}\n");
            
            i++;
        }
    } else {
        msgErr << "POVDisplayDevice: Unknown line style " << lineStyle << sendmsg;
    }

}

// draw a cylinder
void POVDisplayDevice::cylinder(float *a, float *b, float r, int filled) {
  float from[3], to[3];
  float radius;
  filled = filled;  

  // transform the world coordinates
  (transMat.top()).multpoint3d(a, from);
  (transMat.top()).multpoint3d(b, to);
  radius = scale_radius(r);
    
  // draw the cylinder
  
        // draw the cylinder
        fprintf(outfile, "cylinder {\n"); // flat-ended cylinder
        // first point
        fprintf(outfile, "  <%5f, %5f, %5f>,\n", from[0], from[1], -from[2]); 
        // second point
        fprintf(outfile, "  <%5f, %5f, %5f>,\n", to[0], to[1], -to[2]);
        // radius 2
        fprintf(outfile, "  %5f \n", radius);
        fprintf(outfile, "  pigment { rgb<%3.2f, %3.2f, %3.2f> } \n", 
	        matData[colorIndex][DIFFUSE_INDEX+0],
	        matData[colorIndex][DIFFUSE_INDEX+1],
	        matData[colorIndex][DIFFUSE_INDEX+2]);
        fprintf(outfile, "  finish{ phong %3.2f }\n", matData[colorIndex][SHININESS_INDEX]/128.0);
        fprintf(outfile, "}\n");

}

// draw a cone
void POVDisplayDevice::cone(float *a, float *b, float r) {
  float from[3], to[3];
  float radius;
  
  // transform the world coordinates
  (transMat.top()).multpoint3d(a, from);
  (transMat.top()).multpoint3d(b, to);
  radius = scale_radius(r);
    
    
  // draw the cone
  
        // draw the cylinder
        fprintf(outfile, "cone {\n"); // flat-ended cylinder
        // first point
        fprintf(outfile, "  <%5f, %5f, %5f>,\n", from[0], from[1], -from[2]); 
        // radius 1
        fprintf(outfile, "  %5f,\n", radius);
        // second point
        fprintf(outfile, "  <%5f, %5f, %5f>,\n", to[0], to[1], -to[2]);
        // radius 2
        fprintf(outfile, "  %5f \n", float(lineWidth)*DEFAULT_RADIUS);
        fprintf(outfile, "  pigment { rgb<%3.2f, %3.2f, %3.2f> } \n", 
	        matData[colorIndex][DIFFUSE_INDEX+0],
	        matData[colorIndex][DIFFUSE_INDEX+1],
	        matData[colorIndex][DIFFUSE_INDEX+2]);
        fprintf(outfile, "  finish{ phong %3.2f }\n", matData[colorIndex][SHININESS_INDEX]/128.0);
        fprintf(outfile, "}\n");
}

// draw a triangle
void POVDisplayDevice::triangle(float *a, float *b, float *c, float *n1, float *n2, float *n3) {
    float vec1[3], vec2[3], vec3[3];
    float norm1[3], norm2[3], norm3[3];
  
  
    // transform the world coordinates
    (transMat.top()).multpoint3d(a, vec1);
    (transMat.top()).multpoint3d(b, vec2);
    (transMat.top()).multpoint3d(c, vec3);

    // and the normals
    (transMat.top()).multnorm3d(n1, norm1);
    (transMat.top()).multnorm3d(n2, norm2);
    (transMat.top()).multnorm3d(n3, norm3);

    // draw the triangle
  
    fprintf(outfile, "smooth_triangle {\n"); // triangle
    // point one
    fprintf(outfile, "  <%5f, %5f, %5f>,\n", vec1[0], vec1[1], -vec1[2]);
    // normal one
    fprintf(outfile, "  <%5f, %5f, %5f>,\n", norm1[0], norm1[1], -norm1[2]);
    // point two
    fprintf(outfile, "  <%5f, %5f, %5f>,\n", vec2[0], vec2[1], -vec2[2]); 
    // normal two
    fprintf(outfile, "  <%5f, %5f, %5f>,\n", norm2[0], norm2[1], -norm2[2]); 
    // point three 
    fprintf(outfile, "  <%5f, %5f, %5f>,\n", vec3[0], vec3[1], -vec3[2]);
    // normal three 
    fprintf(outfile, "  <%5f, %5f, %5f>\n", norm3[0], norm3[1], -norm3[2]);
    fprintf(outfile, "  pigment { rgb<%3.2f, %3.2f, %3.2f> } \n", 
	    matData[colorIndex][DIFFUSE_INDEX+0],
	    matData[colorIndex][DIFFUSE_INDEX+1],
	    matData[colorIndex][DIFFUSE_INDEX+2]);
    fprintf(outfile, "  finish{ phong %3.2f }\n", matData[colorIndex][SHININESS_INDEX]/128.0);
    fprintf(outfile, "}\n");
  
}

// draw a square
void POVDisplayDevice::square(float *norm, float *a, float *b, float *c, float *d) {
  
     // draw as two triangles
     triangle(a, b, c, norm, norm, norm);
     triangle(a, c, d, norm, norm, norm);
  
}

// write a comment
void POVDisplayDevice::comment (char *s)
{
  fprintf (outfile, "// %s\n", s);
}

///////////////////// public virtual routines

// initialize the file for output
void POVDisplayDevice::write_header() {

        // file for POV (persistance of vision) raytracer.
        fprintf(outfile, "// POV input script : %s ", my_filename);
        fprintf(outfile, "for user %s\n", cuserid(NULL));
        fprintf(outfile, "// try povray +H500 +W%d -I%s ", int(500*Aspect), my_filename);
        fprintf(outfile, "-O%s.tga +P +X +A +FT\n", my_filename);
        
        // Standard POV includes
        fprintf(outfile, "#include \"colors.inc\"\n");
        fprintf(outfile, "#include \"shapes.inc\"\n");
        fprintf(outfile, "#include \"textures.inc\"\n");
                
        // Camera position
        // POV uses a left-handed coordinate system for some reason.
        // I like right-handed, so z(pov) = -z(vmd).
        
        fprintf(outfile, "camera {\n");
        fprintf(outfile, "  location  <%5f, %5f, %5f>\n", eyePos[0],
            eyePos[1], -eyePos[2]);
        fprintf(outfile, "  look_at   <%5f, %5f, %5f>\n", eyeDir[0],
            eyeDir[1], -eyeDir[2]);
        fprintf(outfile, "  up <0.0000, 1.0000, 0.0000>\n");
        fprintf(outfile, "  right <%5f, 0.0000, 0.0000>\n", Aspect);
        fprintf(outfile, "  direction <0, 0, 0.8>\n");
        fprintf(outfile, "  sky <%5f, %5f, %5f>\n", upDir[0], upDir[1],
             -upDir[2]);
        fprintf(outfile, "}\n");
        
        // Lights
        
        for(int i=0;i<DISP_LIGHTS;i++) {
            if(lightDefined[i] && lightOn[i]) {
                fprintf(outfile, "light_source {\n");
                fprintf(outfile, "  <%5f, %5f, %5f>\n", 
                    lightPos[i][0], lightPos[i][1], -lightPos[i][2]);
                fprintf(outfile, "  color rgb<%3.2f, %3.2f, %3.2f>\n",
                    lightColor[i][0], lightColor[i][1], lightColor[i][2]);
                fprintf(outfile, "}\n");
            }
       }
       
       // background color
       fprintf(outfile, "background {\n");
       fprintf(outfile, "  color rgb<%3.2f, %3.2f, %3.2f>\n", backColor[0], 
           backColor[1], backColor[2]);
       fprintf(outfile, "}\n"); 
       
    // that's all for the header.
}

void POVDisplayDevice::write_trailer(void){
  fprintf(outfile, "// End of tokens \n");
  msgInfo << "Token file generation finished" << sendmsg;
}
    
