/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: PSDisplayDevice.h,v $
 *	$Author: ulrich $	$Locker:  $		$State: Exp $
 *	$Revision: 1.5 $	$Date: 1997/03/21 17:50:17 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 *   Save the image to a Postscript file.
 *
 ***************************************************************************/

#ifndef PSDISPLAYDEVICE_H
#define PSDISPLAYDEVICE_H

// PSDisplayDevice is a class which allows rendering of graphics to
// files, in the form of commands for other programs (raytracers, etc.) 
// or image formats, or whatever.

#include <stdio.h>
#include "Matrix4.h"
#include "DepthSortObject2.h"
#include "SortableArray.h"
#include "FileRenderer.h"

#define DTOEYE(x,y,z) ( (x-scaledeyePos[0])*(x-scaledeyePos[0]) + \
			(y-scaledeyePos[1])*(y-scaledeyePos[1]) + \
			(z-scaledeyePos[2])*(z-scaledeyePos[2]) )

class PSDisplayDevice : public FileRenderer {
private:
  float scaledeyePos[3];   // Distances to the eye are calculated in
			   // world coordinates, and this is the
			   // eye position in those world coordinates
  float light_position[3];
  float normLight[3];	   
  float currNorm[3];	   
  float col_ptr[3];
  float textX, textY, textZ;
  int psCounter;
  int sphereRes;
  float screenHor;
  float screenVer;
  char *sphere_res;
  char *sphere_mode;
  char *line_style;
  char *line_width;
  char *color_index;
  char *material_active;
  char *PStext_position;
  float *moredata;
  float XScaleFact, YScaleFact;
  SortableArray <DepthSortObject2> DepthSortList;
  void reset_state(void);
  
public:
  // create the renderer; set the 'visible' name for the renderer list
  PSDisplayDevice(void);
  void output_to_file (int, float rawPoints[][3], char *, int);
  // render the display list
  virtual void render(void *display_list);
  void render_depth_sort (void *);
  void define_PS_procs();
  virtual void render_done ();
  void process_depth_sorted_list();
  void render_token (char *, float *);
  // write any header or trailer info.  This is called by update
  // Yes, you have to write a version for you - even if blank
  void write_trailer(void) {}
  void write_header(void);


protected:
  ////////////////////// various virtual generic graphics commands
  void PSpoint(float * /*xyz*/);
  void PSsphere(float * /*xyzr*/); 
  void PSline(float * /*xyz1*/, float * /*xyz2*/);
  void PScylinder(float * /*xyz1*/, float * /*xyz2*/, 
			float /* radius*/, int /*filled*/) {}
  void PScylinder(int, float *, int);
  void PScone(float * /*xyz1*/, float * /*xyz2*/, int,
	    float /* radius*/); 
  void PStriangleScaled(float *, float *, float *);
  void PStriangle(float * /*xyz1*/, float * /*xyz2*/, float * /*xyz3*/);
  void PSsquare(float * /*xyz1*/, float * /*xyz2*/, 
		      float * /*xyz3*/, float * /*xyz4*/);
  void PStable_circle (float *, float *, float) {}
  void PStext(char *, float, float, float);
  void comment (char *);
  void set_sphere_res (int res) {sphereRes = res;}
  void set_sphere_mode(int) {}
  void set_line_width(int);
  void set_line_style(int);
};

#endif

