/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: PickModeAtomMove.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1996/06/26 14:38:02 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * PickMode is the base class for all objects which perform some form
 * of processing of object selection via a pointer.  When a pointer is used
 * to select an object, the pointer is in a certain pick mode.  A PickList
 * object maintains a list of classes derived from this PickMode; virtual
 * routines in this class are called once an item has been selected, to
 * process and use the motion of the mouse at the starting, during, and end
 * of the picking process.
 *
 * PickModeAtomMove is used to allow the user to change the coordinates of
 * an atom with the pointer.
 *
 ***************************************************************************/
#ifndef PICKMODEATOMMOVE_H
#define PICKMODEATOMMOVE_H

#include "PickMode.h"
class Molecule;
class MoleculeList;


class PickModeAtomMove : public PickMode {

 public:
  // list of different ways we can move atoms
  enum AtomMoveMethod { MOVE_ATOM, MOVE_RESIDUE, MOVE_FRAGMENT, 
			MOVE_MOLECULE, MOVE_METHODS };

 private:
  // name
  char *moveName;

  // our method for moving atoms
  AtomMoveMethod moveMethod;

  // Molecule were currently querying; if NULL, no action currently
  Molecule *pQuery;

  // molecule list with all the molecules to check
  MoleculeList *molList;
  
  // atom which is being moved
  int moveAtom;

  // return molecule pinter if given Pickable pointer is in a molecule;
  // NULL otherwise
  Molecule *check_pickable(Pickable *);
  
  // world position of the pointer for the previous call
  float lastPos[3];

 public:
  // constructor: name of object, list of molecules, type of movement
  PickModeAtomMove(char *, MoleculeList *, AtomMoveMethod);

  // destructor
  virtual ~PickModeAtomMove(void);

  //
  // virtual routines to handle starting a pick, moving during a pick,
  // ending of a pick
  //
  
  // called when a pick is begun:
  //	args = display to use, obj picked, button, tag, dim, pos
  // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
  // For 3D version: x,y,z are transformed position of pointer
  virtual void pick_start(DisplayDevice *,
  				Pickable *, int, int, int, float *);
  
  // called when a pick moves:
  //	args = display to use, obj picked, button, tag, dim, pos
  // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
  // For 3D version: x,y,z are transformed position of pointer
  virtual void pick_move(DisplayDevice *,
  				Pickable *, int, int, int, float *);
  
  // called when a pick ends:
  //	args = display to use, obj picked, button, tag, dim, pos
  // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
  // For 3D version: x,y,z are transformed position of pointer
  virtual void pick_end(DisplayDevice *,
  				Pickable *, int, int, int, float *);
};

#endif

