/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: PickModeDrag.h,v $
 *	$Author: leech $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 95/05/16 21:27:03 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * PickModeDrag is a special PickMode which drags the selected atom,
 *  generating a restraint force fed back to Sigma.
 *
 ***************************************************************************/
#ifndef PICKMODEDRAG_H
#define PICKMODEDRAG_H

#include "PickMode.h"

class PickModeDrag : public PickMode {

private:
  // Pickable we're currently dragging.
  Pickable *pDrag;

  // pointer coords when this started
  float pPos[3];

  // need printout of name
  int needName;

public:
  // constructor
  PickModeDrag(void);
  virtual ~PickModeDrag(void);

  // called when a pick is begun:
  //	args = display to use, obj picked, button, tag, dim, pos
  // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
  // For 3D version: x,y,z are transformed position of pointer
  virtual void pick_start(DisplayDevice *,
				Pickable *, int, int, int, float *);

  // called when a pick moves:
  //	args = display to use, obj picked, button, tag, dim, pos
  // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
  // For 3D version: x,y,z are transformed position of pointer
  virtual void pick_move(DisplayDevice *,
				Pickable *, int, int, int, float *);

  // called when a pick ends:
  //	args = display to use, obj picked, button, tag, dim, pos
  // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
  // For 3D version: x,y,z are transformed position of pointer
  virtual void pick_end(DisplayDevice *,
				Pickable *, int, int, int, float *);
};

#endif

