/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: PickModeMolLabel.h,v $
 *      $Author: dalke $        $Locker:  $                $State: Exp $
 *      $Revision: 1.5 $      $Date: 1997/03/13 17:38:56 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The PickMode object which allows a pointer to be used to create new 
 * geometrical monitoring labels.  This particular version is used only for
 * adding molecular labels, i.e. Atoms, Bonds, Angles, and Dihedrals.  As
 * more atoms are selected, they are remembered until enough have been picked
 * to create the relevant label (i.e. 3 atoms to create an Angle label).
 *
 ***************************************************************************/
#ifndef PICKMODEMOLLABEL_H
#define PICKMODEMOLLABEL_H

#include "PickMode.h"
#include "MoleculeList.h"
class Molecule;
extern MoleculeList *moleculeList;

class PickModeMolLabel : public PickMode {

private:
  // static flag for whether another PickModeMolLabel object has been
  // attempting to select a monitor.  If it is not 0, and not our
  // pick mode id, some other PickModeMolLabel has been trying to
  // select atoms
  static int molPickModeActive;
  static int molPickModeNextID;

  // current id for thie PickModeMolLabel
  int id;

  // name of this object
  char *modeName;

  // Molecule we're currently querying; if NULL, no action currently
  Molecule *pQuery;
  
  // pointer coords when this started
  float pPos[3];

  // items we need to have, and have collected so far, and whether we
  // need to actually print the info out 
  int needItems, haveItems, needName;

  // data for items collected so far
  Molecule **molData;
  char **atomData;

  // return molecule pointer if given Pickable pointer is in a molecule;
  // NULL otherwise
  Molecule *check_pickable(Pickable *p) {
    return (moleculeList ? moleculeList->check_pickable(p)
                          : (Molecule *) NULL);
  }

public:
  // constructor: name, how many items this object needs
  PickModeMolLabel(char *, int);

  // destructor
  virtual ~PickModeMolLabel(void);
  
  //
  // virtual routines to handle starting a pick, moving during a pick,
  // ending of a pick
  //
  
  // called when a pick is begun:
  //	args = display to use, obj picked, button, tag, dim, pos
  // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
  // For 3D version: x,y,z are transformed position of pointer
  virtual void pick_start(DisplayDevice *,
  				Pickable *, int, int, int, float *);
  
  // called when a pick moves:
  //	args = display to use, obj picked, button, tag, dim, pos
  // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
  // For 3D version: x,y,z are transformed position of pointer
  virtual void pick_move(DisplayDevice *,
  				Pickable *, int, int, int, float *);
  
  // called when a pick ends:
  //	args = display to use, obj picked, button, tag, dim, pos
  // For 2D version: x & y are 0 ... 1, represent 'relative, scaled' coords.
  // For 3D version: x,y,z are transformed position of pointer
  virtual void pick_end(DisplayDevice *,
  				Pickable *, int, int, int, float *);
};

#endif

