/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: R3dDisplayDevice.h,v $
 *	$Author: ulrich $	$Locker:  $		$State: Exp $
 *	$Revision: 1.7 $	$Date: 1997/03/21 19:30:05 $
 *
 ***************************************************************************
 * DESCRIPTION:
 * 
 * The R3dDisplayDevice implements routines needed to render to a file 
 * in raster3d format
 *
 ***************************************************************************/
#ifndef R3DDISPLAYDEVICE
#define R3DDISPLAYDEVICE

#include <stdio.h>
#include "FileRenderer.h"


class R3dDisplayDevice : public FileRenderer {


protected:

  //
  // assorted graphics functions
  //
  
  void point(float *);
  void sphere(float *);
  void line(float *, float *);
  void cylinder(float *, float *, float, int);
  void cone(float *, float *, float); 
  void triangle(float *, float *, float *, float *, float *, float *);
  void square(float *, float *, float *, float *, float *);
  void comment (char *);
  
  // otherwise, use what the superclass suggests
public: 
  enum {R3D, TKR3D};
  // constructor/destructor

  R3dDisplayDevice(int which_type_of_r3d_renderers);
  virtual ~R3dDisplayDevice(void);
  
  void write_header(void);
  void write_trailer(void);
}; 

#endif

