#ifndef RADIANCEDISPLAYDEVICE_H
#define RADIANCEDISPLAYDEVICE_H
/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: RadianceDisplayDevice.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.6 $	$Date: 1997/03/23 07:26:20 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *  Writes to the format for Radiance.  For more information about that
 * package, see http://radsite.lbl.gov/radiance/HOME.html .
 *
 ***************************************************************************/


#include <stdio.h>
#include "FileRenderer.h"


class RadianceDisplayDevice : public FileRenderer {

protected:

  //
  // assorted graphics functions
  //
  
  void point(float *);
  void sphere(float *);
  void line(float *, float *);
  void cylinder(float *, float *, float,int);
  void cone(float *, float *, float); 
  void triangle(float *, float *, float *, float *, float *, float *);
  void square(float *, float *, float *, float *, float *);
  void comment (char *);   

  // manage the colors
  ResizeArray<float> red;
  ResizeArray<float> green;
  ResizeArray<float> blue;
  ResizeArray<float> trans;

  // some compiliers (HP's) will complain about this hiding the parent
  // It doesn't know what it is talking about -- they have different
  // signatures.
  void set_color(float r, float g, float b,float t);

   
public: 
  // constructor/destructor

  RadianceDisplayDevice();
  virtual ~RadianceDisplayDevice(void);
  
  void write_header(void);
  void write_trailer(void);
  
}; 

#endif

