/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: RayShadeDisplayDevice.h,v $
 *      $Author: ulrich $        $Locker:  $                $State: Exp $
 *      $Revision: 1.5 $      $Date: 1997/03/21 18:48:11 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * FileRenderer type for the RayShade raytracer
 *
 ***************************************************************************/
#ifndef RAYSHADEDISPLAYDEVICE
#define RAYSHADEDISPLAYDEVICE

#include <stdio.h>
#include "FileRenderer.h"


class RayShadeDisplayDevice : public FileRenderer {

private:

  // output file name
  char *ray_filename;
  
protected:

  // fix the scaling in a hackish manner
  
  float scale_fix(float);

  //
  // assorted graphics functions
  //
  
  void point(float *);
  void sphere(float *);
  void line(float *, float *);
  void cylinder(float *, float *, float,int filled);
  void cone(float *, float *, float); 
  void triangle(float *, float *, float *, float *, float *, float *);
  void square(float *, float *, float *, float *, float *);
  void comment (char *);
   
public: 
  // constructor/destructor

  RayShadeDisplayDevice();
  virtual ~RayShadeDisplayDevice(void);
 
  void write_header(void);
  void write_trailer(void);
  
}; 

#endif

