/*
 * COPYRIGHT 1992, REGENTS OF THE UNIVERSITY OF CALIFORNIA
 *
 *  prm.c - read information from an amber PARM topology file:
 *      atom/residue/bond/charge info, plus force field data.
 *      This file and the accompanying prm.h may be distributed
 *      provided this notice is retained unmodified and provided
 *      that any modifications to the rest of the file are noted
 *      in comments.
 *
 *      Bill Ross, UCSF 1994
 */


/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: ReadPARM.h,v $
 *      $Author: ulrich $        $Locker:  $                $State: Exp $
 *      $Revision: 1.1 $      $Date: 1997/03/20 04:15:00 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************/

// NOTE RCS INFORMATION HEADERS WERE ADDED TO THIS FILE
// Also, This prm reader has been made into a class, with
// data becoming instance variables and function declarations
// becoming method declarations

#ifndef READPARM_H
#define READPARM_H
// #define DOUBLE

#ifdef DOUBLE
#define _REAL		double
#else
#define _REAL		float
#endif

typedef struct parm {
	char	ititl[81];
	int 	IfBox, Nmxrs, IfCap,
		 Natom,  Ntypes,  Nbonh,  Mbona,  Ntheth,  Mtheta, 
		 Nphih,  Mphia,  Nhparm, Nparm, Nnb, Nres,
		 Nbona,  Ntheta,  Nphia,  Numbnd,  Numang,  Nptra,
		 Natyp,  Nphb, Nat3, Ntype2d, Nttyp, Nspm, Iptres, Nspsol,
		 Ipatm, Natcap;
	char 	*AtomNames, *ResNames, *AtomSym, *AtomTree;
	_REAL	*Charges, *Masses, *Rk, *Req, *Tk, *Teq, *Pk, *Pn, *Phase,
		 *Solty, *Cn1, *Cn2, *HB12, *HB6;
	_REAL	Box[3], Cutcap, Xcap, Ycap, Zcap;
	int 	*Iac, *Iblo, *Cno, *Ipres, *ExclAt, *TreeJoin, 
		*AtomRes, *BondHAt1, *BondHAt2, *BondHNum, *BondAt1, *BondAt2, 
		*BondNum, *AngleHAt1, *AngleHAt2, *AngleHAt3, *AngleHNum, 
		*AngleAt1, *AngleAt2, *AngleAt3, *AngleNum, *DihHAt1, 
		*DihHAt2, *DihHAt3, *DihHAt4, *DihHNum, *DihAt1, *DihAt2, 
		*DihAt3, *DihAt4, *DihNum, *Boundary;
} parmstruct;

class ReadPARM {
public:
 ReadPARM(void) {popn = 0;}
 ~ReadPARM(void) {}
 
 int popn;
 parmstruct *prm;
 FILE *open_parm_file (char *name);
 void close_parm_file (FILE *fileptr);
 char *get(int size);
 void preadln(FILE *file, char *name, char* string);
 void readparm (FILE *name);
 void get_parm_atom(int, char *, char *, char *, char *, int *, float *,
   float *);

 void get_parm_bond(int, int fromAtom[], int toAtom[]);
 void get_hydrogen_bond(int, int fromAtom[], int toAtom[]);
 int get_parm_natoms();
 int get_parm_nbonds();
 int get_parm_boxInfo();

};
#endif

