/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: RemoteFormsObj.C,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.9 $	$Date: 1995/10/20 14:28:41 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The on-screen menu to set up a remote connection or attach to a running job
 *
 ***************************************************************************/

#ifdef VMDREMOTE

#include "RemoteFormsObj.h"
#include "CmdRemote.h"
#include "CmdMenu.h"
#include "Remote.h"
#include "Global.h"
#include "utilities.h"

// commands we are interested in
static int numCmds = 6;
static int cmdList[6] = {
	Command::REMOTE_CANCEL,		Command::REMOTE_SETOPT,
	Command::REMOTE_INIT,		Command::REMOTE_NEW,
	Command::REMOTE_READOPT,	Command::REMOTE_WRITEOPT };

/////////////////////////  constructor  
RemoteFormsObj::RemoteFormsObj(UIList *uil, CommandQueue *cq,
        int sh,int bd,int *npos) : FormsObj("remote", uil, cq, bd, npos) {

  // set values of common menu elements
  form = remoteMenu;
  lightButton = remote_menu_button;
  offButton = remote_menu_off;
  
  // register which commands we are interested in
  for(int i=0; i < numCmds; command_wanted(cmdList[i++]));
  
  // turn on if required
  if(sh)
    On();
    
  // current display mode
  currMode = UNKNOWN;
}


/////////////////////////////  private routines  

// initialize the application browser
void RemoteFormsObj::init_app_browser(void) {
  freeze();
    fl_clear_browser(remote_apps);
    if(remote) {
      for(int i=0; i < remote->avail_apps(); i++){
        fl_add_browser_line(remote_apps, remote->avail_app_name(i));
      }
    }
  unfreeze();
}


// initialize the available jobs browser
void RemoteFormsObj::init_job_browser(void) {
  char jobstr[128];
  int pid, uid;

  freeze();
    fl_clear_browser(remote_jobs);
    if(remote)
      for(int i=0; i < remote->running_jobs(); i++) {
        remote->running_job_ids(i, pid, uid);
        sprintf(jobstr, "[pid=%6d]  %s", pid, remote->running_job_name(i));
        fl_add_browser_line(remote_jobs, jobstr);
      }
  unfreeze();
}


// initialize the parameters browser
void RemoteFormsObj::init_param_browser(void) {
  freeze();
    fl_clear_browser(remote_parameters);
    if(remote)
      for(int i=0; i < remote->options(); i++) {
        fl_add_browser_line(remote_parameters, "  ");
	change_param_browser_line(i);
      }
  unfreeze();
}


// change a particular line in the parameter browser
void RemoteFormsObj::change_param_browser_line(int n) {
  char optbuf[128];

  if(remote->option_req(n) && !(remote->option_default(n)))
    strcpy(optbuf,"@C1 ");
  else
    strcpy(optbuf," ");
  strcat(optbuf, remote->option_string(n));
  fl_replace_browser_line(remote_parameters, n+1, optbuf);
}


// set form to edit parameter n
void RemoteFormsObj::edit_parameter(int n) {

  if(remote && n >= 0 && n < remote->options()) {
    freeze();
      if(remote->option_default(n))
        fl_set_input(remote_newvalue, remote->option_default(n));
      else
        fl_set_input(remote_newvalue, "");
      fl_show_object(remote_newvalue);
      fl_show_object(remote_parameters);
      fl_show_object(remote_step3_text);
      fl_hide_object(remote_file_read);
      fl_hide_object(remote_file_write);
      fl_hide_object(remote_run);
    unfreeze();
    currMode = NEW_DATA;
  }
}


// change to a new editing mode
void RemoteFormsObj::change_mode(SetupModes newMode) {
  char appbuffer[64];

  // make sure we're not already in the selected mode
  if(newMode == currMode)
    return;

  freeze();

  // changing from or to NO_REMOTE mode?
  if(currMode == NO_REMOTE) {
    fl_hide_object(remote_machine);
    fl_hide_object(remote_user);
    fl_hide_object(remote_step1_text);
    fl_hide_object(remote_connect);
    fl_show_object(remote_status_machine);
    fl_show_object(remote_status_user);
    fl_show_object(remote_status_app);
    sprintf(appbuffer, "Connected to: %s", remote->host());
    fl_set_object_label(remote_status_machine, appbuffer);
    sprintf(appbuffer, "Username: %s", remote->user());
    fl_set_object_label(remote_status_user, appbuffer);
    fl_set_object_label(remote_status_app, "Application: unknown");
  } else if(newMode == NO_REMOTE) {
    fl_show_object(remote_machine);
    fl_show_object(remote_user);
    fl_show_object(remote_step1_text);
    fl_show_object(remote_connect);
    fl_hide_object(remote_status_machine);
    fl_hide_object(remote_status_user);
    fl_hide_object(remote_status_app);
  }
  
  // changing from or to SELECTING mode?
  if(currMode == SELECTING) {
    fl_hide_object(remote_apps);
    fl_hide_object(remote_jobs);
    fl_hide_object(remote_getparams);
    fl_hide_object(remote_attach);
    fl_hide_object(remote_step2_text);
  } else if(newMode == SELECTING) {
    fl_show_object(remote_apps);
    fl_show_object(remote_jobs);
    fl_show_object(remote_getparams);
    fl_show_object(remote_attach);
    fl_show_object(remote_step2_text);
    init_app_browser();
    init_job_browser();
  }
  
  // changing from or to EDITING mode?
  if(currMode == EDITING) {
    fl_hide_object(remote_file_read);
    fl_hide_object(remote_file_write);
    fl_hide_object(remote_run);
    fl_hide_object(remote_parameters);
    fl_hide_object(remote_step3_text);
  } else if(newMode == EDITING) {
    fl_show_object(remote_file_read);
    fl_show_object(remote_file_write);
    fl_show_object(remote_run);
    fl_show_object(remote_parameters);
    fl_show_object(remote_step3_text);
    sprintf(appbuffer,"Application: %s", remote->app());
    fl_set_object_label(remote_status_app, appbuffer);
    init_param_browser();
  }
  
  // changing from or to NEW_DATA mode?
  if(currMode == NEW_DATA) {
    fl_hide_object(remote_newvalue);
  } else if(newMode == NEW_DATA) {
    edit_parameter(fl_get_browser(remote_parameters) - 1);
  }
  
  unfreeze();

  // finally, indicate the new mode setting
  currMode = newMode;
}

/////////////////////////  protected virtual functions  
// check if the given forms pointer is one for this menu, and generate
// a command if necessary.  Return 'TRUE' if the pointer is for an object
// in this menu.
int RemoteFormsObj::check(FL_OBJECT *obj) {

  if(obj == remote_machine || obj == remote_user || obj == remote_apps ||
  	obj == remote_jobs) {
    // do nothing
    
  } else if(obj == remote_cancel) {
    if(currMode == NEW_DATA)
      change_mode(EDITING);
    else if(currMode == NO_REMOTE)
      addcommand(new CmdMenuShow(id(),FALSE,id()));
    else
      addcommand(new CmdRemoteCancel(id()));
    
  } else if(obj == remote_file_read) {
    char *fname = (char *) fl_show_fselector(
		"Select file with parameter data:", "","*","");
    if(fname)
      addcommand(new CmdRemoteReadopt(fname, id()));
      
  } else if(obj == remote_file_write) {
    char *fname = (char *) fl_show_fselector(
		     "Select parameter data output file:", "","*","");
    if(fname)
      addcommand(new CmdRemoteWriteopt(fname, id()));

  } else if(obj == remote_connect) {
    char *mach = (char *) fl_get_input(remote_machine);
    char *us = (char *) fl_get_input(remote_user);
    if(mach && us && strlen(mach) > 0 && strlen(us) > 0)
      addcommand(new CmdRemoteInit(mach, us, id()));
			
  } else if(obj == remote_getparams) {
    int app = fl_get_browser(remote_apps);
    if(app > 0)
      addcommand(new CmdRemoteNew(app - 1, id()));

  } else if(obj == remote_attach) {
    int job = fl_get_browser(remote_jobs);
    if(job > 0)
      addcommand(new CmdRemoteAttach(job - 1, id()));

  } else if(obj == remote_run) {
    addcommand(new CmdRemoteRun(id()));
    
  } else if(obj == remote_parameters) {
    if(currMode == NEW_DATA)
      edit_parameter(fl_get_browser(remote_parameters) - 1);
    else
      change_mode(NEW_DATA);

  } else if(obj == remote_newvalue) {
    if(remote) {
      char *kw = remote->option_keyword(fl_get_browser(remote_parameters) - 1);
      if(kw)
        addcommand(new CmdRemoteSetopt(kw, (char *) fl_get_input(obj), id()));
    }
    
  } else
    // unknown
    return FALSE;
    
  return TRUE;
}


// do form-specific acting on commands
int RemoteFormsObj::forms_act_on_command(int type, Command *, int suc) {
  SetupModes newMode = currMode;
  
  if(type == Command::REMOTE_INIT || type == Command::REMOTE_CANCEL ||
  	type == Command::REMOTE_NEW || type == Command::REMOTE_ATTACH ||
	type == Command::REMOTE_RUN || type == Command::REMOTE_SETOPT ||
	type == Command::REMOTE_READOPT || type == Command::REMOTE_WRITEOPT) {
    if(suc) {
      // find new mode based on current status, and change to it
      if(!remote)
        newMode = NO_REMOTE;
      else if(remote->editing_parameters())
	newMode = EDITING;
      else
        newMode = SELECTING;

      // did we start a new simulation?
      if(type == Command::REMOTE_RUN || type == Command::REMOTE_ATTACH) {
        addcommand(new CmdMenuShow(id(),FALSE,id()));
      }

      // do we need to change?
      if(newMode != currMode)
        change_mode(newMode);
      else if(type == Command::REMOTE_READOPT || 
      		type == Command::REMOTE_WRITEOPT ||
		type == Command::REMOTE_SETOPT)
        init_param_browser();
    } else if(!remote) {
      change_mode(NO_REMOTE);
    }
  } else
    return FALSE;

  return TRUE;
}


///////////////////////////  public virtual routines  

// initialize the user interface
void RemoteFormsObj::init(void) {
  currMode = UNKNOWN;
  freeze();
    fl_set_input(remote_machine, "");
    fl_set_input(remote_user, username());
    fl_set_browser_fontstyle(remote_parameters,FL_FIXED_STYLE);
    fl_set_browser_fontsize(remote_parameters,FL_SMALL_FONT);

    fl_hide_object(remote_machine);
    fl_hide_object(remote_user);
    fl_hide_object(remote_step1_text);
    fl_hide_object(remote_connect);
    fl_hide_object(remote_status_machine);
    fl_hide_object(remote_status_user);
    fl_hide_object(remote_status_app);
    fl_hide_object(remote_apps);
    fl_hide_object(remote_jobs);
    fl_hide_object(remote_getparams);
    fl_hide_object(remote_attach);
    fl_hide_object(remote_step2_text);
    fl_hide_object(remote_file_read);
    fl_hide_object(remote_file_write);
    fl_hide_object(remote_run);
    fl_hide_object(remote_parameters);
    fl_hide_object(remote_step3_text);
    fl_hide_object(remote_newvalue);

    change_mode(NO_REMOTE);
  unfreeze();
}

// reset the user interface
void RemoteFormsObj::reset(void) {
  // nothing to do here
}

#endif

