/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: RemoteFormsObj.h,v $
 *	$Author: billh $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/05/11 23:42:35 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The on-screen menu to set up a remote connection or attach to a running job
 *
 ***************************************************************************/
#ifndef REMOTEFORMSOBJ_H
#define REMOTEFORMSOBJ_H

#ifdef VMDREMOTE

#include "FormsObj.h"


class RemoteFormsObj : public FormsObj {

private:
  // different modes this menu can be in ... for each mode, a different
  // set of items are shown
  enum SetupModes { NO_REMOTE, SELECTING, EDITING, NEW_DATA, UNKNOWN };

  // which mode are we in?
  SetupModes currMode;

  // initialize app, job, and parameter browsers
  void init_app_browser(void);
  void init_job_browser(void);
  void init_param_browser(void);

  // change a particular line in the parameter browser
  void change_param_browser_line(int);

  // set form to edit parameter n
  void edit_parameter(int);

  // change to a new mode
  void change_mode(SetupModes);

protected:
  // check if the given forms pointer is one for this menu, and generate
  // a command if necessary.  Return 'TRUE' if the pointer is for an object
  // in this menu.
  virtual int check(FL_OBJECT *);

  // do form-specific acting on commands
  virtual int forms_act_on_command(int, Command *, int);

public:
  // class constructor and destructor
  RemoteFormsObj(UIList *, CommandQueue *, int, int, int * = NULL);

  //
  // virtual routines for UI init/display
  //
  
  // initialize the user interface
  virtual void init(void);
  
  // reset the user interface (forces update of all info displays)
  virtual void reset(void);

};

#endif

#endif

