/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: RenderFormsObj.C,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.5 $	$Date: 1996/11/05 04:15:28 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * The on-screen menu to load a new molecule from a set of files.
 *
 ***************************************************************************/

#include <stdio.h>
#include "RenderFormsObj.h"
#include "CmdRender.h"
#include "FileRenderList.h"
#include "FileRenderer.h"
#include "Global.h"
#include "utilities.h"


/////////////////////////  constructor  
RenderFormsObj::RenderFormsObj(UIList *uil, CommandQueue *cq,
	int sh,int bd,int *npos) : FormsObj("render", uil, cq, bd, npos) {
	
  // set values of common menu elements
  form = renderMenu;
  lightButton = render_menu_button;
  offButton = render_menu_off;
  
  // turn on if required
  if(sh)
    On();
}

/////////////////////////////  private routines  

// select a filename
void  RenderFormsObj::choose_filename(FL_OBJECT *txt, char *prompt) {
  freeze();

  // get file name
  char *fname = (char *)fl_show_fselector(prompt, "", "*", "");
  if(fname)
    fl_set_input(txt, fname);

  unfreeze();
}


void RenderFormsObj::reset_render_list(void) {

  if(!fileRenderList)
    return;

  freeze();
    fl_clear_browser(render_formats);
    for(int i=0; i < fileRenderList->num(); i++)
      fl_add_browser_line(render_formats, fileRenderList->name(i));
  unfreeze();
}


//////////////////////  protected virtual routines  

// routine to check the main form for use
int RenderFormsObj::check(FL_OBJECT *obj) {

  if(obj == render_formats) {
    // set the input items to the default command settings
    FileRenderer *frender =
	fileRenderList->find((char *) fl_get_browser_line(obj,
				fl_get_browser(obj)));
    if(frender) {
      fl_set_input(render_file_input,    (char *) frender->
		   default_filename());
      fl_set_input(render_command_input, (char *) frender->
		   default_exec_string());
    }
    
  } else if(obj == render_command_input || obj == render_file_input) {
    ; // do nothing

  } else if(obj == render_browse_button) {
    choose_filename(render_file_input, "Select rendering output file:");

  } else if(obj == render_start_button) {
    // make sure everything is OK
    char *outfile = (char *) fl_get_input(render_file_input);
    char *outcmd = (char *) fl_get_input(render_command_input);
    if(outfile && strlen(outfile) > 0 && fl_get_browser(render_formats) > 0) {
      addcommand(new CmdRender((char *) fl_get_browser_line(render_formats,
	fl_get_browser(render_formats)), outfile, outcmd, id()));
    } else {
      msgErr << "Please select a file format and output filename." << sendmsg;
    }

  } else
    return FALSE;

  return TRUE;
}


// do form-specific acting on commands.  Return whether
// any action was taken on this command.
// Arguments are the command type, command object, and the 
// success of the command (T or F).
int RenderFormsObj::forms_act_on_command(int type, Command *, int) {
  // so I don't get compiler warnings when MSGDEBUG is not defined
  type = type;  

  MSGDEBUG(3,"RenderFormsObj: acting on command " << type << sendmsg);

  // we don't need no stinkin' commands in THIS objects ...
  return FALSE;
}


//////////////////////  public virtual routines  

// initialize the user interface
void RenderFormsObj::init(void) {
  reset();
}


// reset the user interface
void RenderFormsObj::reset(void) {
  freeze();
    reset_render_list();
    fl_deselect_browser(render_formats);
    fl_set_input(render_file_input, "");
    fl_set_input(render_command_input, "");
  unfreeze();
}

