/***************************************************************************
 *cr                                                                       
 *cr            (C) Copyright 1995 The Board of Trustees of the           
 *cr                        University of Illinois                       
 *cr                         All Rights Reserved                        
 *cr                                                                   
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: ResizeArray.h,v $
 *	$Author: dalke $	$Locker:  $		$State: Exp $
 *	$Revision: 1.9 $	$Date: 1996/11/12 02:35:31 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Automatically-adjusting single-dim array template.
 *
 ***************************************************************************/
#ifndef RESIZEARRAY_TEMPLATE_H
#define RESIZEARRAY_TEMPLATE_H


template<class T>
class ResizeArray {

private:
  // list of items, and pointer to current item.
  T *data;

  // max number of items that can be stored in the array
  int sz;
  
  // factor by which to make array larger, if must extend
  float resizeFactor;
  
  // largest number of items that have been accessed so far.
  // this is the largest index used, + 1
  int currSize;

public:
  // constructor: initial size of array, and resizing factor (the amount
  //	by which the max array size is multiplied when the array is
  //	indexed beyond it's current size)
  ResizeArray(int = 10, float = 2.0);
  
  // destructor
  ~ResizeArray(void);

  //
  // query routines about the state of the array
  //
    
  // get/set resize factor
  void resize_factor(float f) { resizeFactor = f; }
  float resize_factor(void) { return resizeFactor; }

  // return maximum size of array
  int max_array_size(void) { return sz; }
  
  // largest number of elements that have been accessed
  int num(void) { return currSize; }

  //
  // routines for accessing array elements
  //

  // return the nth item; assume N is >= 0
  T& item(int);
  
  // [] operator version of the item() routine
  T& operator[](int N) { return item(N); }

  // add a new element to the end of the array.  Return index of new item.
  int append(const T& val) {
    item(currSize) = val;
    return currSize - 1;
  }

  // insert new item after the specified index.  Return index of new item.
  // if specified index is < 0, item put at beginning of list.
  // if specified index is >= num(), item put at end of list.
  int insert_after(int, const T&);

  // insert new item before the specified index.  Return index of new item.
  // if specified index is < 0, item put at beginning of list.
  // if specified index is >= num(), item put at end of list.
  int insert_before(int, const T&);

  // remove the Mth ... Nth items: move all items lower in the
  // array up to fill the empty slots.
  // If both arguments are < 0, removes ALL items.
  // If the second argument is < 0, just removes item m
  void remove(int = (-1), int = (-1));
  
  // scan the array until the first item that matches in the array is
  // found.  Return the index if found, (-1) otherwise.
  int find(const T&);

};

// needed for gcc to get the template definitions (no repository?)
#ifdef __GNUG__
#include "ResizeArray.c"
#endif

#endif

