/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile$
 *	$Author: leech $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $		$Date: 95/05/16 20:54:41 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Subclass of DisplayDevice, this object has routines used by all the
 * different display devices that are Starbase-specific.  Will render drawing
 * commands into a single GL window.
 *
 ***************************************************************************/
#ifndef SBDISPLAYDEVICE_H
#define SBDISPLAYDEVICE_H

#include "SBRenderer.h"

#define GL_STEREO_OFF		0
#define GL_STEREO_CRYSTAL	1
#define GL_STEREO_SIDE		2
#define GL_STEREO_MODES		3

class UITk;
struct Tcl_Interp;

class SBDisplayDevice : public SBRenderer {
private:
    // Cached initial window size & position
    int wsize[2], wloc[2];

    // Actual window operations are done through Tk
    UITk *uitk;
    Tcl_Interp *interp;

    // A number used in constructing the Tk path name
    //	for this window.
    int tkid;

    // Used internally to generate unique path names
    static int next_tkid;

protected:
    // create a new window and set it's characteristics
    void open_window(char *, int *, int *);

    // No stereo support as yet

    // functions used to set perspective for normal or stereo view
    void set_persp(DisplayEye = NOSTEREO);
public:
    // constructor/destructor
    // arguments are the size and location for the window, if known
    SBDisplayDevice(int *size = NULL, int *loc = NULL);
    virtual ~SBDisplayDevice(void);

    //
    // virtual routines for preparing to draw, drawing, and finishing drawing
    //

    virtual void prepare2D(int do_clear = TRUE);  // ready to draw 2D
    virtual void prepare3D(int do_clear = TRUE);  // ready to draw 3D
    virtual void clear(void);			  // erase the device
    virtual void normal(void);			  // ready to draw non-stereo
    virtual void update(int do_update = TRUE);	  // finish up after drawing
    virtual void reshape(void);			  // refresh device after change
    void configure(int, int);			  // refresh device after change

    // Bind the display device to a Tk interpeter which does
    //	the actual window operations.
    void bind_Tk(UITk *);
};


#endif

