/***************************************************************************
 *cr
 *cr		(C) Copyright 1995 The Board of Trustees of the
 *cr			    University of Illinois
 *cr			     All Rights Reserved
 *cr
 ***************************************************************************/

/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: SBRenderer.h,v $
 *	$Author: leech $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $		$Date: 95/07/26 03:16:32 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 * Subclass of DisplayDevice, this object has routines used by all the
 * different display devices that are Starbase-specific.  Will render drawing
 * commands into a single window.  This is not the complete definition,
 * however, of a DisplayDevice; something must provide routines to open
 * windows, reshape, clear, set perspective, etc.  This object contains the
 * code to render a display command list.
 *
 ***************************************************************************/
#ifndef SBRENDERER_H
#define SBRENDERER_H

#include <math.h>
#include "DisplayDevice.h"

class SBRenderer : public DisplayDevice {
private:
    // pointer to data block (should be changed to allow for multiple blocks)
    float *dataBlock;

    // do we need to turn antialiasing and depth-cueing on when materials
    // are turned off?
    int need_aaon, need_cueon;

protected:
    // descriptor of the open Starbase device
    int fd;

    // maximum display size
    int maxwidth, maxheight;

    // current display size (must be no larger than maximum size)
    int width, height;

    // bitmask determining which lights are active
    int lightmask;

    // current text location
    float text_pos[3];

    // current buffer being displayed (for dbuffer_switch)
    int display_buffer;

    // routines to perform various SB-specific graphics operations
    void set_line_width(int);
    void set_line_style(int);
    void set_sphere_res(int);
    void set_sphere_mode(int);
    // triangle with 3 vertices, 3 vertex normals
    void triangle(float *p1, float *, float *, float *n1, float *, float *);
    void square(float *norm, float *, float *, float *, float *);
    void cylinder(float *, float *, int, float);  // slow
#ifndef USE_SLOW_CYLINDERS
    void cylinder(int num, float *edges);  // fast, if precomputed
#endif
    void cone(float *, float *, int, float);
    void sphere(float *, float);

    //
    // protected virtual routines
    //

    // virtual routines to deal with light sources at device level
    // all return success of operation
    virtual int do_define_light(int n, float *color, float *position);
    virtual int do_activate_light(int n, int turnon);

    // virtual routines to deal with materials at device level
    // all return success of operation
    virtual int do_define_material(int n, float *data);
    virtual int do_activate_material(int n, int turnon);

    void translate(float, float, float);
    void scale(float, float, float);
    void rot(float, char);

public:
    // constructor/destructor
    SBRenderer(char *);
    virtual ~SBRenderer(void);

    //
    // virtual routines to affect the device's transformation matrix
    //

    virtual void push(void);		  // push device's curr state on stack
    virtual void pop(void);		  // pop device's curr state from stack
    virtual void loadmatrix(Matrix4 &);   // replace trans matrix with given one
    virtual void multmatrix(Matrix4 &);   // multiply trans matrix with given one

    //
    // virtual routines to find characteristics of display itself
    //

    // return absolute 2D screen coordinates, given 2D or 3D world coordinates.
    virtual void abs_screen_loc_3D(float *, long *);
    virtual void abs_screen_loc_2D(float *, long *);

    // size of physical display object
    virtual void screen_size_mm(long &, long &);
    virtual void screen_size_pixel(long &, long &);

    // Given a 3D point (pos A),
    // and a 2D rel screen pos point (for pos B), computes the 3D point
    // which goes with the second 2D point at pos B.  Result returned in B3D.
    virtual void find_3D_from_2D(float *A3D, float *B2D, float *B3D);

    //
    // virtual functions to turn on/off depth cuing and antialiasing
    //

    virtual void aa_on(void);
    virtual void aa_off(void);
    virtual void cueing_on(void);
    virtual void cueing_off(void);

    //
    // virtual routines for preparing to draw, drawing, and finishing drawing
    //

    virtual void render(void *);	  // process list of draw cmds

};

#endif

